/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildBuff;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.FormulaUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.HandyConfigUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildBuffService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildSacredStoneGui {
    private static final GuildSacredStoneGui INSTANCE = new GuildSacredStoneGui();

    private GuildSacredStoneGui() {
    }

    public static GuildSacredStoneGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.SACRED_STONE_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.SACRED_STONE_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_SACRED_STONE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_SACRED_STONE.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(handyInventory.getId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Integer sacredStoneLevel = guildInfo.getSacredStoneLevel();
        String name = ConfigUtil.SACRED_STONE_CONFIG.getString(sacredStoneLevel + ".name", "");
        int index = ConfigUtil.SACRED_STONE_CONFIG.getInt("info.index");
        String material = ConfigUtil.SACRED_STONE_CONFIG.getString("info.material");
        boolean isEnchant = ConfigUtil.SACRED_STONE_CONFIG.getBoolean("info.isEnchant");
        String infoName = ConfigUtil.SACRED_STONE_CONFIG.getString("info.name", "${sacred_stone_name}").replace("${sacred_stone_name}", name);
        int customModelData = ConfigUtil.SACRED_STONE_CONFIG.getInt("info.custom-model-data");
        List loreList = ConfigUtil.SACRED_STONE_CONFIG.getStringList("info.lore");
        boolean hideFlag = ConfigUtil.SACRED_STONE_CONFIG.getBoolean("info.hideFlag", true);
        ItemStack itemStack = ItemStackUtil.getItemStack(material, infoName, loreList, isEnchant, customModelData, hideFlag, this.replaceMap(guildInfo));
        inventory.setItem(index, itemStack);
        HandyInventoryUtil.setButton(ConfigUtil.SACRED_STONE_CONFIG, inventory, "back");
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        HandyInventoryUtil.setButton(ConfigUtil.SACRED_STONE_CONFIG, inventory, "woodenPickaxe", this.pickaxeReplaceMap("woodenPickaxe", guildPlayer));
        HandyInventoryUtil.setButton(ConfigUtil.SACRED_STONE_CONFIG, inventory, "ironPickaxe", this.pickaxeReplaceMap("ironPickaxe", guildPlayer));
        HandyInventoryUtil.setButton(ConfigUtil.SACRED_STONE_CONFIG, inventory, "goldenPickaxe", this.pickaxeReplaceMap("goldenPickaxe", guildPlayer));
        HandyInventoryUtil.setButton(ConfigUtil.SACRED_STONE_CONFIG, inventory, "diamondPickaxe", this.pickaxeReplaceMap("diamondPickaxe", guildPlayer));
        Map<String, Object> buffMap = HandyConfigUtil.getChildMap(ConfigUtil.SACRED_STONE_CONFIG, "buff");
        for (String key : buffMap.keySet()) {
            Map<String, String> buffReplaceMap = this.buffReplaceMap(player, key, guildInfo);
            Map<String, List<String>> buffBatchReplaceMap = this.buffBatchReplaceMap(player, key, guildInfo);
            HandyInventoryUtil.setButton(ConfigUtil.SACRED_STONE_CONFIG, inventory, "buff." + key, buffReplaceMap, buffBatchReplaceMap);
        }
    }

    private Map<String, String> pickaxeReplaceMap(String type, GuildPlayer guildPlayer) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(3);
        int price = ConfigUtil.SACRED_STONE_CONFIG.getInt(type + ".price", 0);
        replaceMap.put("price", String.valueOf(price));
        replaceMap.put("money", guildPlayer.getMoney().toString());
        String button = ConfigUtil.SACRED_STONE_CONFIG.getString("notExcavated");
        String notMoneyExcavated = ConfigUtil.SACRED_STONE_CONFIG.getString("notMoneyExcavated");
        if (guildPlayer.getMoney() < price) {
            button = notMoneyExcavated;
        }
        if (guildPlayer.getPickaxeTime() != null) {
            String pickaxeTime = DateUtil.format(guildPlayer.getPickaxeTime(), "yyyy-MM-dd");
            if (DateUtil.format(new Date(), "yyyy-MM-dd").equalsIgnoreCase(pickaxeTime)) {
                button = ConfigUtil.SACRED_STONE_CONFIG.getString("excavated", "").replace("${ore}", guildPlayer.getOre().toString());
            }
        }
        replaceMap.put("button", button);
        return replaceMap;
    }

    private Map<String, String> replaceMap(GuildInfo guildInfo) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(9);
        Integer sacredStoneLevel = guildInfo.getSacredStoneLevel();
        Integer money = guildInfo.getMoney();
        String button = ConfigUtil.SACRED_STONE_CONFIG.getString("noButton");
        int value = ConfigUtil.SACRED_STONE_CONFIG.getInt(sacredStoneLevel + ".value", 1);
        int nextPrice = ConfigUtil.SACRED_STONE_CONFIG.getInt(sacredStoneLevel + 1 + ".price", -1);
        int nextValue = ConfigUtil.SACRED_STONE_CONFIG.getInt(sacredStoneLevel + 1 + ".value", value);
        if (nextPrice == -1) {
            button = ConfigUtil.SACRED_STONE_CONFIG.getString("maxButton");
        } else if (money >= nextPrice) {
            button = ConfigUtil.SACRED_STONE_CONFIG.getString("yesButton");
        }
        replaceMap.put("price", String.valueOf(nextPrice));
        replaceMap.put("money", money.toString());
        replaceMap.put("nowLevel", sacredStoneLevel.toString());
        replaceMap.put("nextLevel", String.valueOf(sacredStoneLevel + 1));
        replaceMap.put("nowValue", String.valueOf(value));
        replaceMap.put("nextValue", String.valueOf(nextValue));
        replaceMap.put("button", button);
        replaceMap.put("time", ConfigUtil.SACRED_STONE_CONFIG.getString("time"));
        String name = ConfigUtil.SACRED_STONE_CONFIG.getString(sacredStoneLevel + ".name", "");
        replaceMap.put("sacred_stone_name", name);
        return replaceMap;
    }

    private Map<String, String> buffReplaceMap(Player player, String type, GuildInfo guildInfo) {
        int maxLevel;
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(4);
        String button = ConfigUtil.SACRED_STONE_CONFIG.getString("lock", "");
        String guildOre = guildInfo.getOre() != null ? guildInfo.getOre().toString() : "0";
        String price = ConfigUtil.SACRED_STONE_CONFIG.getString("buff." + type + ".price", "0");
        Map<String, GuildBuff> buffMap = GuildBuffService.getInstance().findByGuildId(guildInfo.getId());
        int level = buffMap.get(type) != null ? buffMap.get(type).getLevel() : 0;
        if (level >= (maxLevel = ConfigUtil.SACRED_STONE_CONFIG.getInt("buff." + type + ".maxLevel"))) {
            button = ConfigUtil.SACRED_STONE_CONFIG.getString("maxLevelMsg", "");
        }
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(4);
        map.put("level", String.valueOf(level + 1));
        String formulaPrice = FormulaUtil.evaluateFormula(PlaceholderApiUtil.set(player, price), map);
        button = button.replace("${guild_ore}", guildOre).replace("${use_ore}", formulaPrice);
        replaceMap.put("level", String.valueOf(level));
        replaceMap.put("maxLevel", String.valueOf(maxLevel));
        replaceMap.put("button", button);
        return replaceMap;
    }

    private Map<String, List<String>> buffBatchReplaceMap(Player player, String type, GuildInfo guildInfo) {
        HashMap<String, List<String>> replaceMap = MapUtil.newHashMapWithExpectedSize(2);
        List attributeList = ConfigUtil.SACRED_STONE_CONFIG.getStringList("buff." + type + ".display");
        if (CollUtil.isEmpty(attributeList)) {
            attributeList = ConfigUtil.SACRED_STONE_CONFIG.getStringList("buff." + type + ".attribute");
        }
        if (CollUtil.isEmpty(attributeList)) {
            return replaceMap;
        }
        Map<String, GuildBuff> buffMap = GuildBuffService.getInstance().findByGuildId(guildInfo.getId());
        int level = buffMap.get(type) != null ? buffMap.get(type).getLevel() : 0;
        ArrayList<String> list = new ArrayList<String>();
        for (String buff : attributeList) {
            String formulaBuff = FormulaUtil.evaluateFormula(PlaceholderApiUtil.set(player, buff), MapUtil.of("level", String.valueOf(level)));
            list.add(formulaBuff);
        }
        replaceMap.put("buff", list);
        int subLevel = buffMap.get(type) != null ? buffMap.get(type).getLevel() + 1 : 1;
        ArrayList<String> subList = new ArrayList<String>();
        for (String buff : attributeList) {
            String formulaBuff = FormulaUtil.evaluateFormula(PlaceholderApiUtil.set(player, buff), MapUtil.of("level", String.valueOf(subLevel)));
            subList.add(formulaBuff);
        }
        replaceMap.put("subBuff", subList);
        int maxLevel = ConfigUtil.SACRED_STONE_CONFIG.getInt("buff." + type + ".maxLevel");
        if (level >= maxLevel) {
            String maxLevelMsg = ConfigUtil.SACRED_STONE_CONFIG.getString("maxLevel", "");
            replaceMap.put("subBuff", Collections.singletonList(maxLevelMsg));
        }
        return replaceMap;
    }
}

