/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuildSettingGui {
    private static final GuildSettingGui INSTANCE = new GuildSettingGui();

    private GuildSettingGui() {
    }

    public static GuildSettingGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.SETTING_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.SETTING_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_SETTING.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_SETTING.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(handyInventory.getId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        boolean menuEnable = ConfigUtil.SETTING_CONFIG.getBoolean("menu.enable");
        if (menuEnable) {
            List<String> loreList = ConfigUtil.SETTING_CONFIG.getStringList("menu.lore");
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(guildInfo.getLogoName());
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(guildInfo.getGuildName()));
            if (CollUtil.isEmpty(loreList)) {
                loreList = StrUtil.strToStrList(guildInfo.getDescription());
            }
            loreList = PlaceholderApiUtil.set(player, loreList);
            itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(ConfigUtil.SETTING_CONFIG.getInt("menu.index"), itemStack);
        }
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "up", this.upReplaceMap(guildInfo));
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "editName", this.editNameReplaceMap(guildInfo));
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "invitation");
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "logoShop");
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "logoWarehouse");
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "apply");
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "pvp", this.createGuildPvpReplaceMap(guildInfo));
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "setSpawn");
        if (StrUtil.isEmpty(guildInfo.getWorldName())) {
            HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "createGuildWorld", this.createGuildWorldReplaceMap(guildInfo));
        } else {
            HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "tpGuildWorld");
        }
        if (guildPlayer.getRoleId() < GuildRoleEnum.TWO.getRoleId()) {
            HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "dissolution");
        }
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "description", this.editDescriptionReplaceMap(guildInfo), GuildUtil.getDescriptionMap(guildInfo.getDescription()));
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "joinMode", this.createGuildJoinModeReplaceMap(guildInfo));
        HandyInventoryUtil.setButton(ConfigUtil.SETTING_CONFIG, inventory, "pane");
    }

    private Map<String, String> upReplaceMap(GuildInfo guildInfo) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(12);
        Integer money = guildInfo.getMoney();
        Integer prosperityDegree = guildInfo.getProsperityDegree();
        Integer level = guildInfo.getLevel();
        String button = ConfigUtil.SETTING_CONFIG.getString("up.noButton");
        int upMoney = ConfigUtil.CONFIG.getInt("guildSetting." + level + ".upMoney");
        int upProsperityDegree = ConfigUtil.CONFIG.getInt("guildSetting." + level + ".upProsperityDegree");
        int upMember = ConfigUtil.CONFIG.getInt("guildSetting." + level + ".upMember", 0);
        if (prosperityDegree >= upProsperityDegree && money >= upMoney && guildInfo.getMemberCount() >= upMember) {
            button = ConfigUtil.SETTING_CONFIG.getString("up.yesButton");
        }
        if (upMoney == 0 && upProsperityDegree == 0 && upMember == 0) {
            button = ConfigUtil.SETTING_CONFIG.getString("up.maxLevel");
        }
        replaceMap.put("level", level.toString());
        replaceMap.put("button", button);
        replaceMap.put("guildMoney", money.toString());
        replaceMap.put("guildProsperityDegree", prosperityDegree.toString());
        replaceMap.put("upMoney", String.valueOf(upMoney));
        replaceMap.put("upProsperityDegree", String.valueOf(upProsperityDegree));
        int maintenanceMoney = ConfigUtil.CONFIG.getInt("guildSetting." + level + ".maintenanceMoney", 0);
        int upMaintenanceMoney = ConfigUtil.CONFIG.getInt("guildSetting." + (level + 1) + ".maintenanceMoney", 0);
        replaceMap.put("maintenanceMoney", String.valueOf(maintenanceMoney));
        replaceMap.put("upMaintenanceMoney", String.valueOf(upMaintenanceMoney));
        int maintenanceActive = ConfigUtil.CONFIG.getInt("guildSetting." + level + ".maintenanceActive", 0);
        int upMaintenanceActive = ConfigUtil.CONFIG.getInt("guildSetting." + (level + 1) + ".maintenanceActive", 0);
        replaceMap.put("maintenanceActive", String.valueOf(maintenanceActive));
        replaceMap.put("upMaintenanceActive", String.valueOf(upMaintenanceActive));
        replaceMap.put("upMember", String.valueOf(upMember));
        replaceMap.put("guildMember", String.valueOf(guildInfo.getMemberCount()));
        return replaceMap;
    }

    private Map<String, String> editNameReplaceMap(GuildInfo guildInfo) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(3);
        Integer money = guildInfo.getMoney();
        String button = ConfigUtil.SETTING_CONFIG.getString("editName.noButton");
        int price = ConfigUtil.SETTING_CONFIG.getInt("editName.price");
        if (money >= price) {
            button = ConfigUtil.SETTING_CONFIG.getString("editName.yesButton");
        }
        replaceMap.put("button", button);
        replaceMap.put("guildMoney", money.toString());
        replaceMap.put("price", String.valueOf(price));
        return replaceMap;
    }

    private Map<String, String> createGuildWorldReplaceMap(GuildInfo guildInfo) {
        String button = ConfigUtil.SETTING_CONFIG.getString("createGuildWorld.createButton");
        if (StrUtil.isNotEmpty(guildInfo.getWorldName())) {
            button = ConfigUtil.SETTING_CONFIG.getString("createGuildWorld.haveButton");
        }
        return MapUtil.of("button", button);
    }

    private Map<String, String> createGuildPvpReplaceMap(GuildInfo guildInfo) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(3);
        String button = ConfigUtil.SETTING_CONFIG.getString("pvp.yesPvp");
        if (guildInfo.getPvpStatus() != null && guildInfo.getPvpStatus().booleanValue()) {
            button = ConfigUtil.SETTING_CONFIG.getString("pvp.noPvp");
        }
        int price = ConfigUtil.SETTING_CONFIG.getInt("pvp.price");
        replaceMap.put("price", String.valueOf(price));
        replaceMap.put("money", String.valueOf(guildInfo.getMoney()));
        replaceMap.put("pvpStatus", button);
        return replaceMap;
    }

    private Map<String, String> createGuildJoinModeReplaceMap(GuildInfo guildInfo) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(3);
        String button = ConfigUtil.SETTING_CONFIG.getString("joinMode.apply");
        if (guildInfo.getJoinMode() != null && !guildInfo.getJoinMode().booleanValue()) {
            button = ConfigUtil.SETTING_CONFIG.getString("joinMode.auto");
        }
        int price = ConfigUtil.SETTING_CONFIG.getInt("joinMode.price");
        replaceMap.put("price", String.valueOf(price));
        replaceMap.put("money", String.valueOf(guildInfo.getMoney()));
        replaceMap.put("joinStatus", button);
        return replaceMap;
    }

    private Map<String, String> editDescriptionReplaceMap(GuildInfo guildInfo) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(3);
        Integer money = guildInfo.getMoney();
        String button = ConfigUtil.SETTING_CONFIG.getString("description.noButton");
        int price = ConfigUtil.SETTING_CONFIG.getInt("description.price");
        if (money >= price) {
            button = ConfigUtil.SETTING_CONFIG.getString("description.yesButton");
        }
        replaceMap.put("button", button);
        replaceMap.put("guildMoney", money.toString());
        replaceMap.put("price", String.valueOf(price));
        return replaceMap;
    }
}

