/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.lib.util;

import com.handy.guild.lib.InitApi;
import com.handy.guild.lib.constants.BaseConstants;
import com.handy.guild.lib.constants.VersionCheckEnum;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.SignUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.HandyHttpUtil;
import com.handy.guild.lib.util.MessageUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class HandyConfigUtil {
    private HandyConfigUtil() {
    }

    public static FileConfiguration loadConfig() {
        FileConfiguration config = HandyConfigUtil.load("config.yml");
        BaseConstants.DEBUG = config.getBoolean("debug");
        String ip = config.getString("ip");
        if (StrUtil.isNotEmpty(ip)) {
            BaseConstants.URL = ip;
        }
        SignUtil.SignConstants.SIGN = config.getString("sign");
        return config;
    }

    public static FileConfiguration loadLangConfig(String language) {
        return HandyConfigUtil.loadLangConfig(language, false);
    }

    public static FileConfiguration loadLangConfig(String language, boolean isZhCn) {
        FileConfiguration langConfig;
        BaseConstants.LANG_CONFIG = langConfig = HandyConfigUtil.load("languages/" + language + ".yml");
        if (isZhCn) {
            if ("zh_CN".equals(language)) {
                HandyConfigUtil.initZhCn();
            } else {
                HandyConfigUtil.initItem();
            }
        }
        return langConfig;
    }

    public static FileConfiguration load(String child) {
        File langFile = new File(InitApi.PLUGIN.getDataFolder(), child);
        if (!langFile.exists()) {
            InitApi.PLUGIN.saveResource(child, false);
        }
        return YamlConfiguration.loadConfiguration((File)langFile);
    }

    public static Map<String, FileConfiguration> loadDirectory(String directoryStr) {
        File[] spawnFileList;
        HashMap<String, FileConfiguration> map = new HashMap<String, FileConfiguration>();
        File directory = new File(InitApi.PLUGIN.getDataFolder(), directoryStr);
        if (!directory.exists()) {
            InitApi.PLUGIN.saveResource(directoryStr, false);
        }
        if ((spawnFileList = directory.listFiles()) == null) {
            return map;
        }
        for (File file : spawnFileList) {
            map.put(file.getName(), HandyConfigUtil.load(directoryStr + file.getName()));
        }
        return map;
    }

    public static boolean createNewFile(String fileName) {
        File file = new File(InitApi.PLUGIN.getDataFolder(), fileName);
        if (!file.exists()) {
            return file.createNewFile();
        }
        return true;
    }

    public static void setPath(FileConfiguration fileConfiguration, String path, Object value, String child) {
        HandyConfigUtil.setPath(fileConfiguration, path, value, null, child);
    }

    public static void setPath(FileConfiguration fileConfiguration, String path, Object value, List<String> comments, String child) {
        try {
            fileConfiguration.set(path, value);
            if (CollUtil.isNotEmpty(comments) && BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_18.getVersionId()) {
                fileConfiguration.setComments(path, comments);
            }
            fileConfiguration.save(new File(InitApi.PLUGIN.getDataFolder(), child));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static void setPathIsNotContains(FileConfiguration fileConfiguration, String path, Object value, List<String> comments, String child) {
        if (fileConfiguration.contains(path)) {
            return;
        }
        HandyConfigUtil.setPath(fileConfiguration, path, value, comments, child);
    }

    public static void loadKey(String key, boolean rst) {
        SignUtil.SignConstants.SECRET_KEY = key;
        SignUtil.setCommandPermission(rst);
        SignUtil.start();
    }

    public static void loadKey(String key) {
        HandyConfigUtil.loadKey(key, false);
    }

    public static boolean exists(String child) {
        File file = new File(InitApi.PLUGIN.getDataFolder(), child);
        return file.exists();
    }

    public static Map<String, String> getStringMapChild(FileConfiguration config, String type) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map<String, Object> values = HandyConfigUtil.getChildMap(config, type);
        for (String key : values.keySet()) {
            map.put(key, config.getString(type + "." + key));
        }
        return map;
    }

    public static Map<String, List<String>> getStringListMapChild(FileConfiguration config, String type) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Map<String, Object> values = HandyConfigUtil.getChildMap(config, type);
        for (String key : values.keySet()) {
            map.put(key, config.getStringList(type + "." + key));
        }
        return map;
    }

    public static Map<String, Object> getChildMap(FileConfiguration config, String type) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ConfigurationSection configurationSection = config.getConfigurationSection(type);
        if (configurationSection == null) {
            return map;
        }
        return configurationSection.getValues(false);
    }

    private static void initZhCn() {
        File zhChFile = new File(InitApi.PLUGIN.getDataFolder(), "zh_cn.json");
        if (zhChFile.exists()) {
            BaseUtil.readJsonFileToJsonCacheMap(zhChFile);
        } else {
            HandyHttpUtil.getZhCn();
        }
        HandyConfigUtil.initItem();
        HandyHttpUtil.setCloudItemJsonCacheMap(BaseConstants.VERSION_CHECK_ENUM.getVersion());
        HandyHttpUtil.setItemName();
    }

    private static void initItem() {
        File itemFile = new File(InitApi.PLUGIN.getDataFolder(), "item.json");
        if (!itemFile.exists()) {
            InitApi.PLUGIN.saveResource("item.json", false);
        }
        try {
            BaseUtil.readJsonFileToItemJsonCacheMap(itemFile);
        }
        catch (Exception e) {
            MessageUtil.sendConsoleMessage("item.json \u52a0\u8f7d\u5931\u8d25,\u539f\u56e0:json\u683c\u5f0f\u5f02\u5e38");
        }
    }
}

