/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.lib.util;

import com.handy.guild.lib.constants.BaseConstants;
import com.handy.guild.lib.constants.VersionCheckEnum;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.BaseUtil;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;

public class TextUtil {
    private TextComponent textComponent;

    private TextUtil() {
    }

    public static TextUtil getInstance() {
        return new TextUtil();
    }

    public TextUtil init(String msg) {
        return this.init(msg, true);
    }

    public TextUtil init(String msg, boolean isColor) {
        this.textComponent = new TextComponent(isColor ? BaseUtil.replaceChatColor(msg) : msg);
        return this;
    }

    public TextUtil addClick(ClickEvent.Action action, String msg) {
        this.textComponent.setClickEvent(new ClickEvent(action, msg));
        return this;
    }

    public TextUtil addClickUrl(String url) {
        return this.addClick(ClickEvent.Action.OPEN_URL, url);
    }

    public TextUtil addClickCommand(String command) {
        return this.addClick(ClickEvent.Action.RUN_COMMAND, command);
    }

    public TextUtil addClickSuggestCommand(String suggestCommand) {
        return this.addClick(ClickEvent.Action.SUGGEST_COMMAND, suggestCommand);
    }

    public TextUtil addClickCopyToClipboard(String text) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_15.getVersionId()) {
            return this;
        }
        return this.addClick(ClickEvent.Action.COPY_TO_CLIPBOARD, BaseUtil.replaceChatColor(text));
    }

    public TextUtil addHoverText(String text) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_16.getVersionId()) {
            return this;
        }
        if (StrUtil.isEmpty(text)) {
            return this;
        }
        this.textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(BaseUtil.replaceChatColor(text))}));
        return this;
    }

    public TextUtil addExtra(TextComponent extra) {
        this.textComponent.addExtra((BaseComponent)extra);
        return this;
    }

    public TextComponent build() {
        return this.textComponent;
    }
}

