/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.PlayerGuild;
import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildLogo;
import com.handy.guild.enter.GuildLogoShop;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.event.GuildCreateEvent;
import com.handy.guild.hook.PlayerChatUtil;
import com.handy.guild.hook.PlayerTaskUtil;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.service.GuildLogoShopService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class GuildCreateEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onGuildCreateEvent(GuildCreateEvent event) {
        String guildName = event.getGuildName().replace("\u00a7", "&");
        Player player = event.getPlayer();
        GuildApplyService.getInstance().updateApplyResultByPlayerName(player.getName(), ApplyTypeEnum.CANCEL.getId());
        GuildInfo guildInfo = new GuildInfo();
        guildInfo.setGuildName(guildName);
        String defaultLogo = ConfigUtil.CONFIG.getString("defaultLogo", "APPLE");
        String logoName = ItemStackUtil.itemStackSerialize(new ItemStack(ItemStackUtil.getMaterial(defaultLogo)));
        Optional<GuildLogoShop> guildLogoShopOptional = GuildLogoShopService.getInstance().findDefaultLogo(1);
        if (guildLogoShopOptional.isPresent()) {
            GuildLogoShop guildLogoShop = guildLogoShopOptional.get();
            guildInfo.setLogoId(guildLogoShop.getId());
            logoName = guildLogoShop.getItemStack();
        }
        guildInfo.setLogoName(logoName);
        guildInfo.setLevel(1);
        guildInfo.setMoney(0);
        guildInfo.setProsperityDegree(0);
        guildInfo.setMonthProsperityDegree(0);
        guildInfo.setMemberCount(1);
        guildInfo.setMemberMaxCount(ConfigUtil.CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".totalNumber"));
        guildInfo.setSacredStoneLevel(1);
        guildInfo.setJoinMode(true);
        guildInfo.setCreator(player.getName());
        guildInfo.setCreateTime(new Date());
        guildInfo.setPvpStatus(ConfigUtil.SETTING_CONFIG.getBoolean("pvp.default", true));
        guildInfo.setOre(0);
        int guildInfoId = GuildInfoService.getInstance().add(guildInfo);
        guildInfo.setId(guildInfoId);
        if (guildLogoShopOptional.isPresent()) {
            GuildLogoShop guildLogoShop = guildLogoShopOptional.get();
            GuildLogo guildLogo = new GuildLogo();
            guildLogo.setGuildInfoId(guildInfoId);
            guildLogo.setLogoId(guildLogoShop.getId());
            guildLogo.setLogoName(guildLogoShop.getItemStack());
            guildLogo.setUseFlag(true);
            GuildLogoService.getInstance().add(guildLogo);
        }
        GuildPlayer guildPlayer = new GuildPlayer();
        guildPlayer.setGuildInfoId(guildInfoId);
        guildPlayer.setGuildInfoName(guildName);
        guildPlayer.setPlayerName(player.getName());
        guildPlayer.setPlayerUuid(player.getUniqueId().toString());
        guildPlayer.setRoleId(GuildRoleEnum.ONE.getRoleId());
        guildPlayer.setPvpStatus(true);
        GuildPlayerService.getInstance().add(guildPlayer);
        GuildConstants.PLAYER_GUILD_MAP.put(player.getUniqueId(), guildPlayer);
        PlayerTitleUtil.createTitle(guildInfo);
        PlayerTaskUtil.createTask(guildInfoId);
        PlayerChatUtil.regChannel(guildInfoId);
        MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("createSucceedMsg"));
        String createSucceedAllMsg = ConfigUtil.CREATE_CONFIG.getString("createSucceedAllMsg", "&8[&a\u2714&8] &7\u606d\u559c\u73a9\u5bb6&a${player}&7\u521b\u5efa\u4e86${name}\u516c\u4f1a");
        if (StrUtil.isNotEmpty(createSucceedAllMsg)) {
            createSucceedAllMsg = createSucceedAllMsg.replace("${player}", player.getName()).replace("${name}", guildName);
            MessageUtil.sendAllMessage(createSucceedAllMsg);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onGuildCreateCommandEvent(GuildCreateEvent event) {
        Player player = event.getPlayer();
        List commandList = ConfigUtil.CREATE_CONFIG.getStringList("command");
        if (CollUtil.isEmpty(commandList)) {
            return;
        }
        for (String command : commandList) {
            if (PlayerGuild.USE_PAPI) {
                command = PlaceholderAPI.setPlaceholders((Player)player, (String)command);
            }
            command = command.replace("${player}", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.trim());
        }
    }
}

