/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.BuffManageUtil;
import com.handy.guild.util.GuildUtil;
import java.util.Date;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

@HandyListener
public class PlayerQuitEventListener
implements Listener {
    @EventHandler
    public void onKick(PlayerKickEvent event) {
        this.removeCache(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.removeCache(event.getPlayer());
    }

    private void removeCache(Player player) {
        GuildConstants.SPAWN_WAIT_TIME.remove(player.getUniqueId());
        GuildConstants.SPAWN_TP_WAIT_TIME.remove(player.getUniqueId());
        MatchConstants.GUILD_PVP_PREPARATION_LOCATION_MAP.remove(player.getUniqueId());
        GuildConstants.CREATE_GUILD_INFO_MAP.remove(player.getUniqueId());
        GuildConstants.PLAYER_GUILD_MAP.remove(player.getUniqueId());
        GuildConstants.INVITATION_PLAYER_MAP.remove(player.getName());
        GuildConstants.PLAYER_API_PVP_MAP.remove(player.getUniqueId());
        GuildUtil.guildPvpDeath(player);
        GuildUtil.guildSeasonPvpDeath(player);
        BuffManageUtil.removeBuff(player);
        HandySchedulerUtil.runTaskAsynchronously(() -> GuildPlayerService.getInstance().updateLastQuitTimeByPlayerName(player.getName(), new Date()));
    }
}

