/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

@HandyListener
public class PlayerTeleportEventListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleportEvent(PlayerTeleportEvent event) {
        if (event.getTo() == null) {
            return;
        }
        boolean guildWordCheck = PlayerTeleportEventListener.isGuildWordCheck(event.getPlayer(), event.getTo().getWorld());
        if (guildWordCheck) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(BaseUtil.getLangMsg("noJoinGuildWorld"));
        }
    }

    private static boolean isGuildWordCheck(Player player, World world) {
        if (player.isOp()) {
            return false;
        }
        if (world == null) {
            return false;
        }
        String worldName = world.getName();
        if (!worldName.contains("world_guild")) {
            return false;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findByWorldName(worldName);
        if (!guildInfoOptional.isPresent()) {
            return false;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return true;
        }
        if (!guildPlayerOptional.get().getGuildInfoId().equals(guildInfoOptional.get().getId())) {
            return true;
        }
        PlayerTeleportEventListener.setFly(player);
        return false;
    }

    private static void setFly(Player player) {
        boolean fly = ConfigUtil.WORLD_CONFIG.getBoolean("fly");
        if (!fly) {
            return;
        }
        HandySchedulerUtil.runTask(() -> {
            player.setAllowFlight(true);
            player.setFlying(true);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPvpPlayerTeleportEvent(PlayerTeleportEvent event) {
        this.season(event);
        this.match(event);
    }

    private void match(PlayerTeleportEvent event) {
        if (MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return;
        }
        if (MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(event.getPlayer().getUniqueId()) == null) {
            return;
        }
        event.setCancelled(true);
    }

    private void season(PlayerTeleportEvent event) {
        if (SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return;
        }
        if (SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(event.getPlayer().getUniqueId()) == null) {
            return;
        }
        event.setCancelled(true);
    }
}

