/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.inventory.GuildBankGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildBankClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_BANK.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Integer guildId = handyInventory.getId();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.BANK_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Integer money = guildPlayer.getMoney();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.BANK_CONFIG, "small")) {
            int price = ConfigUtil.BANK_CONFIG.getInt("small.price");
            if (money < price) {
                MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("noButton"));
                return;
            }
            GuildPlayerService.getInstance().subtractMoneyById(guildPlayer.getId(), price);
            GuildPlayerService.getInstance().addGuildMoneyById(guildPlayer.getId(), price);
            GuildInfoService.getInstance().addMoneyById(guildId, price);
            MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("succeedMsg"));
            GuildBankGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.BANK_CONFIG, "big")) {
            int price = ConfigUtil.BANK_CONFIG.getInt("big.price");
            if (money < price) {
                MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("noButton"));
                return;
            }
            GuildPlayerService.getInstance().subtractMoneyById(guildPlayer.getId(), price);
            GuildPlayerService.getInstance().addGuildMoneyById(guildPlayer.getId(), price);
            GuildInfoService.getInstance().addMoneyById(guildId, price);
            MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("succeedMsg"));
            GuildBankGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.BANK_CONFIG, "all")) {
            if (money < 1) {
                MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("noButton"));
                return;
            }
            GuildPlayerService.getInstance().subtractMoneyById(guildPlayer.getId(), money);
            GuildPlayerService.getInstance().addGuildMoneyById(guildPlayer.getId(), money);
            GuildInfoService.getInstance().addMoneyById(guildId, money);
            MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("succeedMsg"));
            GuildBankGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.BANK_CONFIG, "custom")) {
            if (money < 1) {
                MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("noButton"));
                return;
            }
            GuildConstants.CREATE_GUILD_INFO_MAP.put(player.getUniqueId(), "custom");
            MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("custom.customMsg"));
            handyInventory.syncClose();
        }
    }
}

