/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.inventory.ConfirmGui;
import com.handy.guild.inventory.GuildManageMemberGui;
import com.handy.guild.inventory.GuildMemberGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildManageMemberClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_MANAGE_MEMBER_CREATE.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Integer guildId = handyInventory.getId();
        Integer guildPlayerId = Integer.valueOf(handyInventory.getObj().toString());
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MANAGE_MEMBER_CONFIG, "back")) {
            Inventory inventory = GuildMemberGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findById(guildPlayerId);
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MANAGE_MEMBER_CONFIG, "ban")) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(guildPlayer.getPlayerUuid()));
            GuildUtil.callPlayerLeaveGuildEvent(offlinePlayer, guildPlayerId);
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        Optional<GuildPlayer> clickGuildPlayerOpt = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!clickGuildPlayerOpt.isPresent()) {
            return;
        }
        GuildPlayer clickGuildPlayer = clickGuildPlayerOpt.get();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MANAGE_MEMBER_CONFIG, "up")) {
            if (clickGuildPlayer.getRoleId() >= guildPlayer.getRoleId() || clickGuildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
                return;
            }
            int roleId = guildPlayer.getRoleId() - 1;
            if (GuildRoleEnum.ONE.getRoleId() >= roleId) {
                Inventory inventory = ConfirmGui.getInstance().createGui(player, guildId, "up", guildPlayerId);
                handyInventory.syncOpen(inventory);
                return;
            }
            this.setCache(handyInventory, guildPlayerId, roleId);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MANAGE_MEMBER_CONFIG, "down")) {
            int roleId = guildPlayer.getRoleId() + 1;
            if (GuildRoleEnum.FOUR.getRoleId() < roleId) {
                return;
            }
            this.setCache(handyInventory, guildPlayerId, roleId);
        }
    }

    private void setCache(HandyInventory handyInventory, Integer guildPlayerId, int roleId) {
        GuildPlayerService.getInstance().updateRoleIdById(guildPlayerId, roleId);
        GuildManageMemberGui.getInstance().setInventoryDate(handyInventory);
        Optional<GuildPlayer> playerOptional = GuildPlayerService.getInstance().findById(guildPlayerId);
        if (!playerOptional.isPresent()) {
            return;
        }
        GuildPlayer player = playerOptional.get();
        UUID uuid = UUID.fromString(player.getPlayerUuid());
        if (GuildConstants.PLAYER_GUILD_MAP.containsKey(uuid)) {
            GuildConstants.PLAYER_GUILD_MAP.put(uuid, GuildPlayerService.getInstance().findById(guildPlayerId).orElse(null));
        }
    }
}

