/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildNoticeRead;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.inventory.GuildNoticeGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildNoticeReadService;
import com.handy.guild.service.GuildNoticeService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildNoticeClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_NOTICE.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.NOTICE_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.NOTICE_CONFIG, "search")) {
            String type = null;
            if ("all".equals(handyInventory.getSearchType())) {
                type = "noRead";
            }
            if ("noRead".equals(handyInventory.getSearchType())) {
                type = "all";
            }
            Inventory inventory = GuildNoticeGui.getInstance().createGui(player, handyInventory.getId(), type);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.NOTICE_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                GuildNoticeGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.NOTICE_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                GuildNoticeGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.NOTICE_CONFIG, "send")) {
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(handyInventory.getId());
            if (!guildInfoOptional.isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            int price = ConfigUtil.NOTICE_CONFIG.getInt("send.price");
            if (guildInfo.getMoney() < price) {
                MessageUtil.sendMessage(player, ConfigUtil.NOTICE_CONFIG.getString("send.noButton"));
                return;
            }
            GuildConstants.CREATE_GUILD_INFO_MAP.put(player.getUniqueId(), "send");
            MessageUtil.sendMessage(player, ConfigUtil.NOTICE_CONFIG.getString("send.content"));
            handyInventory.syncClose();
            return;
        }
        Integer id = map.get(rawSlot);
        if (id == null) {
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (guildPlayer.getRoleId() < GuildRoleEnum.TWO.getRoleId()) {
            GuildNoticeService.getInstance().delById(id);
            MessageUtil.sendMessage(player, ConfigUtil.NOTICE_CONFIG.getString("delMsg"));
            GuildNoticeGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        List<Integer> readNoticeIds = GuildNoticeReadService.getInstance().findGuildNoticeId(handyInventory.getId(), player.getName());
        if (readNoticeIds.contains(id)) {
            return;
        }
        GuildNoticeRead guildNoticeRead = new GuildNoticeRead();
        guildNoticeRead.setGuildInfoId(handyInventory.getId());
        guildNoticeRead.setGuildNoticeId(id);
        guildNoticeRead.setReadPlayerName(player.getName());
        guildNoticeRead.setReadPlayerUuid(player.getUniqueId().toString());
        guildNoticeRead.setReadTime(new Date());
        GuildNoticeReadService.getInstance().add(guildNoticeRead);
        MessageUtil.sendMessage(player, ConfigUtil.NOTICE_CONFIG.getString("readMsg"));
        GuildNoticeGui.getInstance().setInventoryDate(handyInventory);
    }
}

