/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.PlayerGuild;
import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.constants.GuildSortEnum;
import com.handy.guild.constants.ShopSearchEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.inventory.ConfirmGui;
import com.handy.guild.inventory.GuildActivityGui;
import com.handy.guild.inventory.GuildBankGui;
import com.handy.guild.inventory.GuildMemberGui;
import com.handy.guild.inventory.GuildNoticeGui;
import com.handy.guild.inventory.GuildOpenGui;
import com.handy.guild.inventory.GuildSacredStoneGui;
import com.handy.guild.inventory.GuildSettingGui;
import com.handy.guild.inventory.GuildShopGui;
import com.handy.guild.inventory.GuildSignInGui;
import com.handy.guild.inventory.GuildTaskGui;
import com.handy.guild.inventory.GuildTitleGui;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildViewClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_VIEW.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "notice")) {
            Inventory inventory = GuildNoticeGui.getInstance().createGui(player, handyInventory.getId(), "all");
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "member")) {
            Inventory inventory = GuildMemberGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "spawn")) {
            handyInventory.syncClose();
            PlayerSchedulerUtil.syncPerformCommand(player, "plg spawn");
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "task")) {
            Inventory inventory = GuildTaskGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "shop")) {
            Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!guildPlayerOptional.isPresent()) {
                return;
            }
            GuildPlayer guildPlayer = guildPlayerOptional.get();
            int buyRoleLimit = ConfigUtil.VIEW_CONFIG.getInt("shop.buyRoleLimit", 4);
            if (guildPlayer.getRoleId() > buyRoleLimit) {
                return;
            }
            Inventory inventory = GuildShopGui.getInstance().createGui(player, handyInventory.getId(), ShopSearchEnum.ALL.getType());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "bank")) {
            Inventory inventory = GuildBankGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "signin")) {
            Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!guildPlayerOptional.isPresent()) {
                return;
            }
            GuildPlayer guildPlayer = guildPlayerOptional.get();
            long between = DateUtil.between(guildPlayer.getJoinTime(), new Date());
            int joinUseCooling = ConfigUtil.CONFIG.getInt("joinUseCooling", 0);
            long time = (long)joinUseCooling - between;
            if (time > 0L) {
                String joinCoolingMsg = BaseUtil.getLangMsg("joinUseCoolingMsg").replace("${time}", time + "");
                MessageUtil.sendMessage(player, joinCoolingMsg);
                return;
            }
            Inventory inventory = GuildSignInGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "buff")) {
            if (!PlayerGuild.USE_TITLE) {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("playerTitleFailureMsg"));
            } else {
                Inventory inventory = GuildTitleGui.getInstance().createGui(player, handyInventory.getId());
                handyInventory.syncOpen(inventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "sacredStone")) {
            Inventory inventory = GuildSacredStoneGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "activity")) {
            Inventory inventory = GuildActivityGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.VIEW_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            HandySchedulerUtil.runTask(() -> player.chat("/" + command.trim()));
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "exit")) {
            Inventory inventory = ConfirmGui.getInstance().createGui(player, handyInventory.getId(), "exit", null);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "admin")) {
            Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!guildPlayerOptional.isPresent()) {
                return;
            }
            GuildPlayer guildPlayer = guildPlayerOptional.get();
            if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
                return;
            }
            Inventory inventory = GuildSettingGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "back")) {
            Inventory inventory = GuildOpenGui.getInstance().createGui(player, GuildSortEnum.PROSPERITY_DEGREE.getName());
            handyInventory.syncOpen(inventory);
        }
    }
}

