/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.inventory.ViewLogoShopGui;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.service.GuildLogoShopService;
import com.handy.guild.util.ConfigUtil;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ViewLogoShopClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.VIEW_LOGO_SHOP.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LOGO_SHOP_CONFIG, "back")) {
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LOGO_SHOP_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                ViewLogoShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LOGO_SHOP_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                ViewLogoShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        Integer id = map.get(rawSlot);
        if (id != null) {
            GuildLogoShopService.getInstance().delById(id);
            GuildLogoService.getInstance().delByLogoId(id);
            ViewLogoShopGui.getInstance().setInventoryDate(handyInventory);
        }
    }
}

