/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.match;

import com.handy.guild.PlayerGuild;
import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPvpLog;
import com.handy.guild.enter.GuildPvpPlayerLog;
import com.handy.guild.event.GuildPvpEndEvent;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.param.GuildPvpPlayerParam;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPvpLogService;
import com.handy.guild.service.GuildPvpPlayerLogService;
import com.handy.guild.util.BuffManageUtil;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.KitPvpUtil;
import com.handy.guild.util.LeatherUtil;
import com.handy.playerrace.api.PlayerRaceApi;
import com.handy.playertitle.api.PlayerTitleApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@HandyListener
public class GuildPvpEndEventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onGuildPvpEnd(GuildPvpEndEvent event) {
        HandySchedulerUtil.runTaskLater(() -> this.issueReward(event), 20L);
    }

    public void issueReward(GuildPvpEndEvent event) {
        Integer failGuildId = event.getFailGuildId();
        Integer winGuildId = event.getWinGuildId();
        List<Integer> guildIdList = Arrays.asList(failGuildId, winGuildId);
        List<GuildInfo> guildInfoList = GuildInfoService.getInstance().findByIds(guildIdList);
        Map<Integer, GuildInfo> guildInfoMap = guildInfoList.stream().collect(Collectors.toMap(GuildInfo::getId, v -> v));
        String failGuildName = guildInfoMap.get(failGuildId).getGuildName();
        String winGuildName = guildInfoMap.get(winGuildId).getGuildName();
        ArrayList allPlayerList = new ArrayList();
        List winPlayerList = MatchConstants.GUILD_PVP_START_PLAYER_MAP.getOrDefault(winGuildId, new ArrayList());
        List failPlayerList = MatchConstants.GUILD_PVP_START_PLAYER_MAP.getOrDefault(failGuildId, new ArrayList());
        allPlayerList.addAll(winPlayerList);
        allPlayerList.addAll(failPlayerList);
        ArrayList<String> uuidList = new ArrayList<String>();
        for (GuildPvpPlayerParam player : allPlayerList) {
            uuidList.add(player.getPlayerUuid().toString());
            Location location = MatchConstants.GUILD_PVP_START_PLAYER_LOCATION_MAP.get(player.getPlayerUuid());
            MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.remove(player.getPlayerUuid());
            MatchConstants.GUILD_PVP_START_PLAYER_LOCATION_MAP.remove(player.getPlayerUuid());
            Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(player.getPlayerUuid());
            if (!onlinePlayerOpt.isPresent()) continue;
            Player guildOnlinePlayer = onlinePlayerOpt.get();
            String matePvpTitleMsg = ConfigUtil.ACTIVITY_CONFIG.getString("matePvpTitleMsg");
            String matePvpFinishSubTitleMsg = ConfigUtil.ACTIVITY_CONFIG.getString("matePvpFinishSubTitleMsg", "${win}").replace("${win}", winGuildName).replace("${fail}", failGuildName);
            MessageUtil.sendTitle(guildOnlinePlayer, matePvpTitleMsg, matePvpFinishSubTitleMsg);
            GuildPvpEndEventListener.endTp(MatchConstants.LOOK_LOCATION.get(winGuildId), location, guildOnlinePlayer);
        }
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByPlayerUuids(uuidList);
        Map<Integer, List<GuildPlayer>> guildPlayerMap = guildPlayerList.stream().collect(Collectors.groupingBy(GuildPlayer::getGuildInfoId));
        boolean rst = this.sendReward(winGuildId, guildPlayerMap, true);
        this.sendReward(failGuildId, guildPlayerMap, false);
        String matePvpFinishAllMsg = ConfigUtil.ACTIVITY_CONFIG.getString(rst ? "matePvpFinishAllMsg" : "matePvpUnlimitedFinishAllMsg", "").replace("${win}", winGuildName).replace("${fail}", failGuildName);
        MessageUtil.sendAllMessage(matePvpFinishAllMsg);
        for (Integer guildId : guildIdList) {
            MatchConstants.GUILD_PVP_START_PLAYER_MAP.remove(guildId);
            MatchConstants.GUILD_PVP_START_LOCATION_MAP.remove(guildId);
            MatchConstants.START_TIME.remove(guildId);
            MatchConstants.LOOK_LOCATION.remove(guildId);
        }
    }

    private boolean sendReward(Integer guildId, Map<Integer, List<GuildPlayer>> guildPlayerMap, boolean isWin) {
        int count = GuildPvpLogService.getInstance().findByGuildInfoIdAndStartTime(guildId, DateUtil.getToday());
        if (count >= ConfigUtil.ACTIVITY_CONFIG.getInt("matePvp.number")) {
            return false;
        }
        int matePvpReward = ConfigUtil.ACTIVITY_CONFIG.getInt(isWin ? "matePvpWin" : "matePvpFail");
        String matePvpMsg = ConfigUtil.ACTIVITY_CONFIG.getString(isWin ? "matePvpWinMsg" : "matePvpFailMsg", "").replace("${money}", String.valueOf(matePvpReward));
        for (GuildPlayer guildPlayer : (List)guildPlayerMap.getOrDefault(guildId, new ArrayList())) {
            GuildPlayerService.getInstance().addMoneyById(guildPlayer.getId(), matePvpReward);
            MessageUtil.sendMessage(guildPlayer.getPlayerName(), matePvpMsg);
        }
        return true;
    }

    public static void endTp(Location lookLocation, Location location, Player player) {
        if (player.isDead()) {
            return;
        }
        GuildPvpEndEventListener.tp(lookLocation, location, player);
    }

    private static void tp(Location lookLocation, Location location, Player player) {
        String pvpEndModel;
        switch (pvpEndModel = ConfigUtil.CONFIG.getString("pvpEndModel", "default")) {
            default: {
                boolean teleport = PlayerSchedulerUtil.teleport((Entity)player, location);
                if (teleport) break;
                MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("tpFailureMsg"));
                PlayerSchedulerUtil.performCommand(player, "spawn");
                break;
            }
            case "lookLocation": {
                PlayerSchedulerUtil.teleport((Entity)player, lookLocation != null ? lookLocation : location);
                break;
            }
            case "spawn": {
                PlayerSchedulerUtil.performCommand(player, "spawn");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onGuildPvpEndBuff(GuildPvpEndEvent event) {
        Integer winGuildId = event.getWinGuildId();
        Integer failGuildId = event.getFailGuildId();
        ArrayList pvpPlayerParamList = new ArrayList();
        HashMap<Integer, List<GuildPvpPlayerParam>> guildPvpStartPlayerMap = new HashMap<Integer, List<GuildPvpPlayerParam>>(MatchConstants.GUILD_PVP_START_PLAYER_MAP);
        pvpPlayerParamList.addAll(guildPvpStartPlayerMap.getOrDefault(winGuildId, new ArrayList()));
        pvpPlayerParamList.addAll(guildPvpStartPlayerMap.getOrDefault(failGuildId, new ArrayList()));
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            for (GuildPvpPlayerParam guildPvpPlayerParam : pvpPlayerParamList) {
                UUID playerUuid = guildPvpPlayerParam.getPlayerUuid();
                Player guildOnlinePlayer = Bukkit.getPlayer((UUID)playerUuid);
                if (guildOnlinePlayer == null || !guildOnlinePlayer.isOnline()) continue;
                if (ConfigUtil.KIT_PVP_CONFIG.getBoolean("maxHealth.enable", false)) {
                    Double maxHealth = KitPvpUtil.GUILD_PVP_START_PLAYER_HEALTH_MAP.get(playerUuid);
                    guildOnlinePlayer.setMaxHealth(maxHealth.doubleValue());
                    KitPvpUtil.GUILD_PVP_START_PLAYER_HEALTH_MAP.remove(playerUuid);
                }
                if (PlayerGuild.USE_TITLE && ConfigUtil.KIT_PVP_CONFIG.getBoolean("playerTitleBuff", true)) {
                    PlayerTitleApi.getInstance().setBuff(guildOnlinePlayer);
                    MessageUtil.sendMessage(guildOnlinePlayer, ConfigUtil.KIT_PVP_CONFIG.getString("playerTitleBuffOnMsg"));
                }
                if (PlayerGuild.USE_RACE && ConfigUtil.KIT_PVP_CONFIG.getBoolean("playerRaceBuff", true)) {
                    PlayerRaceApi.getInstance().resetPlayerRace(guildOnlinePlayer);
                    MessageUtil.sendMessage(guildOnlinePlayer, ConfigUtil.KIT_PVP_CONFIG.getString("playerRaceBuffOnMsg"));
                }
                if (ConfigUtil.KIT_PVP_CONFIG.getBoolean("equipment", false)) {
                    LeatherUtil.setPlayerItemStack(guildOnlinePlayer);
                }
                if (PlayerGuild.USE_ADAPT && ConfigUtil.KIT_PVP_CONFIG.getBoolean("adapt", false)) {
                    MessageUtil.sendMessage(guildOnlinePlayer, ConfigUtil.KIT_PVP_CONFIG.getString("adaptOnMsg"));
                }
                BuffManageUtil.callBuffEvent(guildOnlinePlayer);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onGuildPvpEndLog(GuildPvpEndEvent event) {
        HashMap<Integer, List<GuildPvpPlayerParam>> guildPvpStartPlayerMap = new HashMap<Integer, List<GuildPvpPlayerParam>>(MatchConstants.GUILD_PVP_START_PLAYER_MAP);
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            Date endTime = new Date();
            Integer failGuildId = event.getFailGuildId();
            Date startTime = MatchConstants.START_TIME.getOrDefault(failGuildId, new Date());
            Optional<GuildInfo> failGuildInfoOpt = GuildInfoService.getInstance().findById(failGuildId);
            if (!failGuildInfoOpt.isPresent()) {
                return;
            }
            GuildInfo failGuildInfo = failGuildInfoOpt.get();
            List failPvpPlayerParamList = guildPvpStartPlayerMap.getOrDefault(failGuildId, new ArrayList());
            GuildPvpLog failGuildPvpLog = new GuildPvpLog();
            failGuildPvpLog.setType(GuildActivityType.MATCH.getType());
            failGuildPvpLog.setGuildInfoId(failGuildId);
            failGuildPvpLog.setGuildInfoName(failGuildInfo.getGuildName());
            failGuildPvpLog.setStartTime(startTime);
            failGuildPvpLog.setResult(false);
            failGuildPvpLog.setEndTime(endTime);
            int failGuildPvpLogId = GuildPvpLogService.getInstance().add(failGuildPvpLog);
            for (GuildPvpPlayerParam guildPvpPlayerParam : failPvpPlayerParamList) {
                GuildPvpPlayerLog guildPvpPlayerLog = new GuildPvpPlayerLog();
                guildPvpPlayerLog.setGuildPvpLogId(failGuildPvpLogId);
                guildPvpPlayerLog.setGuildInfoId(failGuildId);
                guildPvpPlayerLog.setGuildInfoName(failGuildInfo.getGuildName());
                guildPvpPlayerLog.setPlayerName(guildPvpPlayerParam.getPlayerName());
                guildPvpPlayerLog.setPlayerUuid(guildPvpPlayerParam.getPlayerUuid().toString());
                guildPvpPlayerLog.setKill(guildPvpPlayerParam.getKill());
                guildPvpPlayerLog.setDie(1);
                guildPvpPlayerLog.setStartTime(startTime);
                guildPvpPlayerLog.setEndTime(endTime);
                GuildPvpPlayerLogService.getInstance().add(guildPvpPlayerLog);
            }
            Integer winGuildId = event.getWinGuildId();
            Optional<GuildInfo> winGuildInfoOpt = GuildInfoService.getInstance().findById(winGuildId);
            if (!winGuildInfoOpt.isPresent()) {
                return;
            }
            GuildInfo winGuildInfo = winGuildInfoOpt.get();
            List winPvpPlayerParamList = guildPvpStartPlayerMap.getOrDefault(winGuildId, new ArrayList());
            GuildPvpLog winGuildPvpLog = new GuildPvpLog();
            winGuildPvpLog.setType(GuildActivityType.MATCH.getType());
            winGuildPvpLog.setGuildInfoId(winGuildId);
            winGuildPvpLog.setGuildInfoName(winGuildInfo.getGuildName());
            winGuildPvpLog.setStartTime(startTime);
            winGuildPvpLog.setResult(true);
            winGuildPvpLog.setEndTime(endTime);
            int winGuildPvpLogId = GuildPvpLogService.getInstance().add(winGuildPvpLog);
            for (GuildPvpPlayerParam guildPvpPlayerParam : winPvpPlayerParamList) {
                GuildPvpPlayerLog guildPvpPlayerLog = new GuildPvpPlayerLog();
                guildPvpPlayerLog.setGuildPvpLogId(winGuildPvpLogId);
                guildPvpPlayerLog.setGuildInfoId(winGuildId);
                guildPvpPlayerLog.setGuildInfoName(winGuildInfo.getGuildName());
                guildPvpPlayerLog.setPlayerName(guildPvpPlayerParam.getPlayerName());
                guildPvpPlayerLog.setPlayerUuid(guildPvpPlayerParam.getPlayerUuid().toString());
                guildPvpPlayerLog.setKill(guildPvpPlayerParam.getKill());
                guildPvpPlayerLog.setDie(guildPvpPlayerParam.getIsDeath() != false ? 1 : 0);
                guildPvpPlayerLog.setStartTime(startTime);
                guildPvpPlayerLog.setEndTime(endTime);
                GuildPvpPlayerLogService.getInstance().add(guildPvpPlayerLog);
            }
        });
    }
}

