/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildNoticeRead;
import com.handy.guild.lib.db.Db;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GuildNoticeReadService {
    private GuildNoticeReadService() {
    }

    public static GuildNoticeReadService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildNoticeRead guildNoticeRead) {
        Db.use(GuildNoticeRead.class).execution().insert(guildNoticeRead);
    }

    public List<GuildNoticeRead> findByGuildIdAndPlayerName(Integer guildId, String playerName) {
        Db<GuildNoticeRead> db = Db.use(GuildNoticeRead.class);
        db.where().eq(GuildNoticeRead::getGuildInfoId, guildId).eq(GuildNoticeRead::getReadPlayerName, playerName);
        return db.execution().list();
    }

    public List<Integer> findGuildNoticeId(Integer guildId, String playerName) {
        List<GuildNoticeRead> guildNoticeReadList = this.findByGuildIdAndPlayerName(guildId, playerName);
        return guildNoticeReadList.stream().map(GuildNoticeRead::getGuildNoticeId).collect(Collectors.toList());
    }

    public void delByGuildNoticeId(Integer guildNoticeId) {
        Db<GuildNoticeRead> use = Db.use(GuildNoticeRead.class);
        use.where().eq(GuildNoticeRead::getGuildNoticeId, guildNoticeId);
        use.execution().delete();
    }

    public Map<Integer, Integer> findMapByGuildNoticeIds(List<Integer> guildNoticeIds) {
        Db<GuildNoticeRead> use = Db.use(GuildNoticeRead.class);
        use.where().in(GuildNoticeRead::getGuildNoticeId, guildNoticeIds);
        List<GuildNoticeRead> list = use.execution().list();
        return list.stream().collect(Collectors.groupingBy(GuildNoticeRead::getGuildNoticeId, Collectors.collectingAndThen(Collectors.toList(), List::size)));
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildNoticeRead> use = Db.use(GuildNoticeRead.class);
        use.where().eq(GuildNoticeRead::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildNoticeRead> findAll() {
        return Db.use(GuildNoticeRead.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildNoticeReadService INSTANCE = new GuildNoticeReadService();

        private SingletonHolder() {
        }
    }
}

