/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildPlayerSignIn;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.db.Db;
import java.util.List;
import java.util.Optional;

public class GuildPlayerSignInService {
    private GuildPlayerSignInService() {
    }

    public static GuildPlayerSignInService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildPlayerSignIn guildPlayerSignIn) {
        return Db.use(GuildPlayerSignIn.class).execution().insert(guildPlayerSignIn);
    }

    public Optional<GuildPlayerSignIn> findByPlayerName(String playerName) {
        Db<GuildPlayerSignIn> use = Db.use(GuildPlayerSignIn.class);
        use.where().eq(GuildPlayerSignIn::getPlayerName, playerName).ge(GuildPlayerSignIn::getSignInTime, DateUtil.getToday());
        return use.execution().selectOne();
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildPlayerSignIn> use = Db.use(GuildPlayerSignIn.class);
        use.where().eq(GuildPlayerSignIn::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildPlayerSignIn> findAll() {
        return Db.use(GuildPlayerSignIn.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildPlayerSignInService INSTANCE = new GuildPlayerSignInService();

        private SingletonHolder() {
        }
    }
}

