/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildPvp;
import com.handy.guild.lib.db.Db;
import java.util.List;
import java.util.Optional;

public class GuildPvpService {
    private GuildPvpService() {
    }

    public static GuildPvpService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildPvp guildPvp) {
        Db.use(GuildPvp.class).execution().insert(guildPvp);
    }

    public void batchAdd(List<GuildPvp> guildPvpList) {
        Db.use(GuildPvp.class).execution().insertBatch(guildPvpList);
    }

    public void updateJoinById(Integer id, Boolean isJoin) {
        Db<GuildPvp> use = Db.use(GuildPvp.class);
        use.update().set(GuildPvp::getIsJoin, isJoin);
        use.execution().updateById(id);
    }

    public Optional<GuildPvp> findByGuildInfoId(Integer guildInfoId) {
        Db<GuildPvp> playerDb = Db.use(GuildPvp.class);
        playerDb.where().eq(GuildPvp::getGuildInfoId, guildInfoId).eq(GuildPvp::getSeason, this.findSeason());
        return playerDb.execution().selectOne();
    }

    public List<GuildPvp> findBySeason() {
        Db<GuildPvp> playerDb = Db.use(GuildPvp.class);
        playerDb.where().eq(GuildPvp::getSeason, this.findSeason()).eq(GuildPvp::getIsStart, false);
        return playerDb.execution().list();
    }

    public void update(GuildPvp guildPvp) {
        Db<GuildPvp> use = Db.use(GuildPvp.class);
        use.update().set(GuildPvp::getIsStart, guildPvp.getIsStart()).set(GuildPvp::getStartTime, guildPvp.getStartTime());
        use.execution().updateById(guildPvp.getId());
    }

    public Integer findSeason() {
        Db<GuildPvp> playerDb = Db.use(GuildPvp.class);
        playerDb.where().orderByDesc(GuildPvp::getSeason).eq(GuildPvp::getIsStart, false).limit(1, 1);
        Optional<GuildPvp> guildPvpOptional = playerDb.execution().selectOne();
        if (guildPvpOptional.isPresent()) {
            return guildPvpOptional.get().getSeason();
        }
        return this.findMaxSeason() + 1;
    }

    private Integer findMaxSeason() {
        Db<GuildPvp> playerDb = Db.use(GuildPvp.class);
        playerDb.where().orderByDesc(GuildPvp::getSeason).limit(1, 1);
        Optional<GuildPvp> guildPvpOptional = playerDb.execution().selectOne();
        return guildPvpOptional.isPresent() ? guildPvpOptional.get().getSeason() : 0;
    }

    public List<GuildPvp> findAll() {
        return Db.use(GuildPvp.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildPvpService INSTANCE = new GuildPvpService();

        private SingletonHolder() {
        }
    }
}

