/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildTask;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import java.util.List;

public class GuildTaskService {
    private GuildTaskService() {
    }

    public static GuildTaskService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildTask guildTask) {
        return Db.use(GuildTask.class).execution().insert(guildTask);
    }

    public List<GuildTask> findSeasonTask() {
        Db<GuildTask> use = Db.use(GuildTask.class);
        use.where().eq(GuildTask::getStatus, false).eq(GuildTask::getDemandSuccess, true).ge(GuildTask::getStartDate, DateUtil.getMonday()).le(GuildTask::getEndDate, DateUtil.getSunday());
        return use.execution().list();
    }

    public void updateStatusById(List<Integer> ids, boolean status) {
        Db<GuildTask> use = Db.use(GuildTask.class);
        use.update().set(GuildTask::getStatus, status);
        use.where().in(GuildTask::getId, ids);
        use.execution().update();
    }

    public void updateDemandSuccess(Integer id, boolean demandSuccess) {
        Db<GuildTask> use = Db.use(GuildTask.class);
        use.update().set(GuildTask::getDemandSuccess, demandSuccess);
        use.execution().updateById(id);
    }

    public Page<GuildTask> page(Integer guildId, Integer pageNum, Integer pageSize) {
        Db<GuildTask> db = Db.use(GuildTask.class);
        db.where().eq(GuildTask::getGuildInfoId, guildId).ge(GuildTask::getStartDate, DateUtil.getMonday()).le(GuildTask::getEndDate, DateUtil.getSunday()).limit(pageNum, pageSize).orderByDesc(GuildTask::getId);
        return db.execution().page();
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildTask> use = Db.use(GuildTask.class);
        use.where().eq(GuildTask::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildTask> findAll() {
        return Db.use(GuildTask.class).execution().list();
    }

    public Integer findCount(Integer guildId) {
        Db<GuildTask> db = Db.use(GuildTask.class);
        db.where().eq(GuildTask::getGuildInfoId, guildId).ge(GuildTask::getStartDate, DateUtil.getMonday()).le(GuildTask::getEndDate, DateUtil.getSunday());
        return db.execution().count();
    }

    private static class SingletonHolder {
        private static final GuildTaskService INSTANCE = new GuildTaskService();

        private SingletonHolder() {
        }
    }
}

