/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.util;

import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPvp;
import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.enter.GuildTask;
import com.handy.guild.hook.PlayerTaskUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPvpLocationService;
import com.handy.guild.service.GuildPvpService;
import com.handy.guild.service.GuildTaskService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class GuildRunTaskTimer {
    private static final Semaphore SEASON_PVP_TASK_LOCK = new Semaphore(1);
    private static final Semaphore GUILD_TASK_REFRESH_LOCK = new Semaphore(1);
    private static final Semaphore GUILD_TASK_REWARD_LOCK = new Semaphore(1);
    private static final Semaphore MAINTENANCE_FUNDS_LOCK = new Semaphore(1);
    private static final Semaphore CLEAR_WEEK_MONEY_LOCK = new Semaphore(1);

    private GuildRunTaskTimer() {
    }

    public static void init() {
        GuildRunTaskTimer.guildSacredStone();
        GuildRunTaskTimer.clearMonthProsperityDegree();
        HandySchedulerUtil.runTaskTimerAsynchronously(() -> {
            GuildRunTaskTimer.seasonPvpTask();
            GuildRunTaskTimer.guildTaskRefresh();
            GuildRunTaskTimer.guildTaskReward();
            GuildRunTaskTimer.guileMaintenanceFunds();
            GuildRunTaskTimer.clearWeekMoney();
        }, 1L, 1200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void seasonPvpTask() {
        if (!SEASON_PVP_TASK_LOCK.tryAcquire()) {
            return;
        }
        try {
            String seasonPvpRemindMsg;
            int startDate = ConfigUtil.ACTIVITY_CONFIG.getInt("seasonPvp.startDate");
            Integer todayWeek = DateUtil.dayOfWeekEnum(new Date());
            if (todayWeek != startDate) {
                return;
            }
            String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
            String startTime = ConfigUtil.ACTIVITY_CONFIG.getString("seasonPvp.startTime", "");
            List remindTimeList = ConfigUtil.ACTIVITY_CONFIG.getStringList("seasonPvp.remindTime");
            if (CollUtil.isNotEmpty(remindTimeList) && remindTimeList.contains(time) && StrUtil.isNotEmpty(seasonPvpRemindMsg = ConfigUtil.ACTIVITY_CONFIG.getString("season.seasonPvpRemindMsg"))) {
                seasonPvpRemindMsg = seasonPvpRemindMsg.replace("${time}", startTime);
                MessageUtil.sendAllMessage(seasonPvpRemindMsg);
            }
            if (!time.equals(startTime)) {
                return;
            }
            if (!ConfigUtil.ACTIVITY_CONFIG.getBoolean("seasonPvp.enable", true)) {
                return;
            }
            GuildRunTaskTimer.startSeason();
        }
        finally {
            SEASON_PVP_TASK_LOCK.release();
        }
    }

    public static void startSeason() {
        List<GuildPvp> guildPvpList = GuildPvpService.getInstance().findBySeason();
        if (CollUtil.isEmpty(guildPvpList)) {
            MessageUtil.sendAllMessage(ConfigUtil.ACTIVITY_CONFIG.getString("seasonNoMsg"));
            return;
        }
        for (GuildPvp guildPvp : guildPvpList) {
            guildPvp.setIsStart(true);
            guildPvp.setStartTime(new Date());
            GuildPvpService.getInstance().update(guildPvp);
        }
        guildPvpList = guildPvpList.stream().filter(GuildPvp::getIsJoin).collect(Collectors.toList());
        List<Integer> guildInfoIdList = guildPvpList.stream().map(GuildPvp::getGuildInfoId).collect(Collectors.toList());
        List<GuildInfo> guildInfoList = GuildInfoService.getInstance().findByIds(guildInfoIdList);
        List guildInfoNameList = guildInfoList.stream().map(GuildInfo::getGuildName).collect(Collectors.toList());
        Integer season = guildPvpList.get(0).getSeason();
        MessageUtil.sendConsoleMessage("\u7b2c" + season + "\u8d5b\u5b63\u516c\u4f1a\u6218\u5f00\u59cb, \u53c2\u8d5b\u516c\u4f1a:" + CollUtil.listToStr(guildInfoNameList));
        if (guildPvpList.size() < 2) {
            MessageUtil.sendAllMessage(ConfigUtil.ACTIVITY_CONFIG.getString("seasonNoMsg"));
            return;
        }
        List<GuildPvpLocation> seasonLocationList = GuildPvpLocationService.getInstance().findByType(GuildActivityType.SEASON.getType());
        if (CollUtil.isEmpty(seasonLocationList)) {
            MessageUtil.sendAllMessage(ConfigUtil.PVP_LOCATION_CONFIG.getString("noSeasonLocation"));
            return;
        }
        GuildUtil.callGuildSeasonPvpPreparationEvent(guildPvpList.stream().map(GuildPvp::getGuildInfoId).collect(Collectors.toList()), season);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void guildTaskReward() {
        if (!GUILD_TASK_REWARD_LOCK.tryAcquire()) {
            return;
        }
        try {
            String time;
            if (!ConfigUtil.TASK_CONFIG.getBoolean("refresh")) {
                return;
            }
            Integer todayWeek = DateUtil.dayOfWeekEnum(new Date());
            if (todayWeek.intValue() != ConfigUtil.TASK_CONFIG.getInt("startDate", 7)) {
                return;
            }
            String startTime = ConfigUtil.TASK_CONFIG.getString("startTime", "23:00");
            if (!startTime.equals(time = DateUtil.format(new Date(), "HH:mm"))) {
                return;
            }
            MessageUtil.sendConsoleMessage("\u516c\u4f1a\u4efb\u52a1 \u5f00\u59cb\u7ed3\u7b97\u65f6\u95f4:\u661f\u671f" + todayWeek + " " + time);
            List<GuildTask> seasonTask = GuildTaskService.getInstance().findSeasonTask();
            MessageUtil.sendConsoleMessage("\u516c\u4f1a\u4efb\u52a1 \u672c\u5468\u5b8c\u6210\u4efb\u52a1\u6570\u91cf" + seasonTask.size());
            if (CollUtil.isEmpty(seasonTask)) {
                return;
            }
            for (GuildTask guildTask : seasonTask) {
                int guildMoney = ConfigUtil.TASK_CONFIG.getInt("guildTask." + guildTask.getTaskId() + ".reward.guildMoney");
                int guildProsperityDegree = ConfigUtil.TASK_CONFIG.getInt("guildTask." + guildTask.getTaskId() + ".reward.guildProsperityDegree");
                GuildInfoService.getInstance().addMoneyById(guildTask.getGuildInfoId(), guildMoney);
                GuildInfoService.getInstance().addProsperityDegreeById(guildTask.getGuildInfoId(), guildProsperityDegree);
                String rewardMsg = ConfigUtil.TASK_CONFIG.getString("rewardMsg", "");
                String msg = rewardMsg.replace("${taskName}", guildTask.getTaskName()).replace("${guildMoney}", guildMoney + "").replace("${guildProsperityDegree}", guildProsperityDegree + "");
                List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildTask.getGuildInfoId());
                for (GuildPlayer guildPlayer : guildPlayerList) {
                    MessageUtil.sendMessage(guildPlayer.getPlayerName(), msg);
                }
                MessageUtil.sendConsoleMessage(msg + " \u516c\u4f1aID:" + guildTask.getGuildInfoId());
            }
            List<Integer> idList = seasonTask.stream().map(GuildTask::getId).collect(Collectors.toList());
            GuildTaskService.getInstance().updateStatusById(idList, true);
            MessageUtil.sendConsoleMessage("\u6bcf\u5468\u4efb\u52a1\u7ed3\u7b97\u53d1\u5956 \u5b8c\u6210\u65f6\u95f4:" + DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        }
        finally {
            GUILD_TASK_REWARD_LOCK.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void guildTaskRefresh() {
        if (!GUILD_TASK_REFRESH_LOCK.tryAcquire()) {
            return;
        }
        try {
            if (!ConfigUtil.TASK_CONFIG.getBoolean("refresh")) {
                return;
            }
            if (DateUtil.dayOfWeekEnum(new Date()) != 1) {
                return;
            }
            if (!"01:00".equals(DateUtil.format(new Date(), "HH:mm"))) {
                return;
            }
            List<GuildInfo> guildInfos = GuildInfoService.getInstance().findAll();
            for (GuildInfo guildInfo : guildInfos) {
                PlayerTaskUtil.createTask(guildInfo.getId());
                String refreshMsg = ConfigUtil.TASK_CONFIG.getString("refreshMsg", "");
                List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildInfo.getId());
                for (GuildPlayer guildPlayer : guildPlayerList) {
                    MessageUtil.sendMessage(guildPlayer.getPlayerUuid(), refreshMsg);
                }
            }
            MessageUtil.sendConsoleMessage("\u91cd\u7f6e\u4efb\u52a1\u5b8c\u6210\u65f6\u95f4:" + DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        }
        finally {
            GUILD_TASK_REFRESH_LOCK.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void guileMaintenanceFunds() {
        if (!MAINTENANCE_FUNDS_LOCK.tryAcquire()) {
            return;
        }
        try {
            if (!"00:00".equals(DateUtil.format(new Date(), "HH:mm"))) {
                return;
            }
            List<GuildInfo> guildInfos = GuildInfoService.getInstance().findAll();
            for (GuildInfo guildInfo : guildInfos) {
                int maintenanceActive;
                int maintenanceMoney = ConfigUtil.CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".maintenanceMoney", 0);
                if (maintenanceMoney > 0) {
                    if (guildInfo.getMoney() >= maintenanceMoney) {
                        GuildInfoService.getInstance().subtractMoneyById(guildInfo.getId(), maintenanceMoney);
                    } else {
                        GuildInfoService.getInstance().setMoneyById(guildInfo.getId(), 0);
                    }
                }
                if ((maintenanceActive = ConfigUtil.CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".maintenanceActive", 0)) <= 0) continue;
                if (guildInfo.getProsperityDegree() >= maintenanceActive) {
                    GuildInfoService.getInstance().subtractProsperityDegreeById(guildInfo.getId(), maintenanceActive);
                    continue;
                }
                GuildInfoService.getInstance().setProsperityDegreeById(guildInfo.getId(), 0);
            }
            MessageUtil.sendConsoleMessage("\u516c\u4f1a\u7ef4\u62a4\u8d44\u91d1\u6263\u9664\u5b8c\u6210\u65f6\u95f4:" + DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        }
        finally {
            MAINTENANCE_FUNDS_LOCK.release();
        }
    }

    private static void clearWeekMoney() {
        if (!CLEAR_WEEK_MONEY_LOCK.tryAcquire()) {
            return;
        }
        try {
            Date date = new Date();
            if (DateUtil.dayOfWeekEnum(date) != 1) {
                return;
            }
            if (!"00:00".equals(DateUtil.format(date, "HH:mm"))) {
                return;
            }
            int num = GuildPlayerService.getInstance().clearWeekMoney();
            MessageUtil.sendConsoleMessage("\u6e05\u7406\u5468\u8d21\u732e\u6210\u529f,\u6e05\u7406\u65f6\u95f4:" + DateUtil.format(date, "yyyy-MM-dd HH:mm:ss") + ",\u672c\u6b21\u6e05\u7406:" + num + "\u6570\u636e");
        }
        finally {
            CLEAR_WEEK_MONEY_LOCK.release();
        }
    }

    private static void guildSacredStone() {
        HandySchedulerUtil.runTaskTimerAsynchronously(() -> {
            List<GuildInfo> guildInfoList = GuildInfoService.getInstance().list();
            if (CollUtil.isEmpty(guildInfoList)) {
                return;
            }
            ArrayList<String> playerNameList = new ArrayList<String>();
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                playerNameList.add(onlinePlayer.getName());
            }
            Map<Object, Object> guildPlayerMap = MapUtil.of();
            if (CollUtil.isNotEmpty(playerNameList)) {
                List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByPlayerNameList(playerNameList);
                guildPlayerMap = guildPlayerList.stream().collect(Collectors.groupingBy(GuildPlayer::getGuildInfoId));
            }
            for (GuildInfo guildInfo : guildInfoList) {
                List guildPlayerList = (List)guildPlayerMap.get(guildInfo.getId());
                if (CollUtil.isEmpty(guildPlayerList)) continue;
                Integer sacredStoneLevel = guildInfo.getSacredStoneLevel();
                int value = ConfigUtil.SACRED_STONE_CONFIG.getInt(sacredStoneLevel + ".value", 1);
                GuildInfoService.getInstance().addProsperityDegreeById(guildInfo.getId(), value * guildPlayerList.size());
            }
        }, 1L, ConfigUtil.SACRED_STONE_CONFIG.getLong("time") * 20L);
    }

    private static void clearMonthProsperityDegree() {
        HandySchedulerUtil.runTaskTimerAsynchronously(() -> {
            if (!"01 00".equals(DateUtil.format(new Date(), "dd HH"))) {
                return;
            }
            List<GuildInfo> guildInfoList = GuildInfoService.getInstance().list();
            if (CollUtil.isEmpty(guildInfoList)) {
                return;
            }
            for (GuildInfo guildInfo : guildInfoList) {
                GuildInfoService.getInstance().setMonthProsperityDegreeById(guildInfo.getId(), 0);
            }
            for (GuildInfo guildInfo : guildInfoList) {
                HashMap<Integer, List<OfflinePlayer>> member = MapUtil.of();
                List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildInfo.getId());
                Map<Integer, List<GuildPlayer>> guildPlayerMap = guildPlayerList.stream().collect(Collectors.groupingBy(GuildPlayer::getRoleId));
                for (Integer roleId : guildPlayerMap.keySet()) {
                    List<GuildPlayer> playerList = guildPlayerMap.get(roleId);
                    if (CollUtil.isEmpty(playerList)) continue;
                    ArrayList<OfflinePlayer> offlinePlayerList = new ArrayList<OfflinePlayer>();
                    for (GuildPlayer guildPlayer : playerList) {
                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(guildPlayer.getPlayerUuid()));
                        offlinePlayerList.add(offlinePlayer);
                    }
                    member.put(roleId, offlinePlayerList);
                }
                GuildUtil.callGuildClearMonthProsperityDegreeEvent(member, guildInfo.getGuildName(), guildInfo.getMonthProsperityDegree());
            }
            MessageUtil.sendConsoleMessage("\u516c\u4f1a\u6708\u5ea6\u6d3b\u8dc3\u6e05\u7406,\u6e05\u7406\u65f6\u95f4:" + DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        }, 1L, 72000L);
    }
}

