/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.util;

import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildNotice;
import com.handy.guild.enter.GuildNoticeRead;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.lib.util.TextUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildNoticeReadService;
import com.handy.guild.service.GuildNoticeService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class NoticeUtil {
    private NoticeUtil() {
    }

    public static void sendNotice(Player player, String msg) {
        NoticeUtil.sendNotice(player, msg, true);
    }

    public static void sendNotice(Player player, String msg, boolean isCheck) {
        String[] split = msg.split("#");
        if (split.length != 2) {
            MessageUtil.sendMessage(player, ConfigUtil.NOTICE_CONFIG.getString("send.content"));
            return;
        }
        String title = split[0];
        String content = split[1];
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (isCheck && NoticeUtil.check(player, content, guildPlayer)) {
            return;
        }
        GuildNotice guildNotice = new GuildNotice();
        guildNotice.setGuildInfoId(guildPlayer.getGuildInfoId());
        guildNotice.setTitle(title);
        guildNotice.setContent(content);
        guildNotice.setSendPlayerName(player.getName());
        guildNotice.setSendPlayerUuid(player.getUniqueId().toString());
        guildNotice.setCreateTime(new Date());
        int guildNoticeId = GuildNoticeService.getInstance().add(guildNotice);
        MessageUtil.sendMessage(player, ConfigUtil.NOTICE_CONFIG.getString("send.okButton"));
        GuildNoticeRead guildNoticeRead = new GuildNoticeRead();
        guildNoticeRead.setGuildInfoId(guildPlayer.getGuildInfoId());
        guildNoticeRead.setGuildNoticeId(guildNoticeId);
        guildNoticeRead.setReadPlayerName(player.getName());
        guildNoticeRead.setReadPlayerUuid(player.getUniqueId().toString());
        guildNoticeRead.setReadTime(new Date());
        GuildNoticeReadService.getInstance().add(guildNoticeRead);
        NoticeUtil.sendNoticeMsg(title, guildPlayer);
    }

    private static void sendNoticeMsg(String title, GuildPlayer guildPlayer) {
        List<GuildPlayer> guildPlayers = GuildPlayerService.getInstance().findByGuildId(guildPlayer.getGuildInfoId());
        List<String> playerNameList = guildPlayers.stream().map(GuildPlayer::getPlayerName).filter(playerName -> !playerName.equals(guildPlayer.getPlayerName())).collect(Collectors.toList());
        String sendNoticeMsg = ConfigUtil.NOTICE_CONFIG.getString("sendNoticeMsg", "").replace("${title}", title);
        String lookNotice = ConfigUtil.NOTICE_CONFIG.getString("lookNotice");
        TextComponent textComponent = TextUtil.getInstance().init(sendNoticeMsg).build();
        textComponent.addExtra((BaseComponent)TextUtil.getInstance().init(lookNotice).addClickCommand("/plg me notice").build());
        MessageUtil.sendMessage(playerNameList, textComponent);
    }

    private static boolean check(Player player, String content, GuildPlayer guildPlayer) {
        int maxFont = ConfigUtil.NOTICE_CONFIG.getInt("send.maxFont");
        if (BaseUtil.stripColor(content).length() > maxFont) {
            String lengthFailureMsg = ConfigUtil.NOTICE_CONFIG.getString("lengthFailureMsg", "").replace("${length}", maxFont + "");
            MessageUtil.sendMessage(player, lengthFailureMsg);
            return true;
        }
        List<String> guildDescriptionList = StrUtil.strToStrList(content);
        int maxLine = ConfigUtil.NOTICE_CONFIG.getInt("send.maxLine");
        for (String guildDescription : guildDescriptionList) {
            if (BaseUtil.stripColor(guildDescription).length() <= maxLine) continue;
            String lengthFailureMsg = ConfigUtil.NOTICE_CONFIG.getString("lengthFailureMsg", "").replace("${length}", maxLine + "");
            MessageUtil.sendMessage(player, lengthFailureMsg);
            return true;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            return true;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.ONE.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return true;
        }
        int price = ConfigUtil.NOTICE_CONFIG.getInt("send.price");
        if (guildInfo.getMoney() < price) {
            MessageUtil.sendMessage(player, ConfigUtil.NOTICE_CONFIG.getString("send.noButton"));
            return true;
        }
        GuildInfoService.getInstance().subtractMoneyById(guildInfo.getId(), price);
        return false;
    }
}

