/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp;

import cn.handyplus.warp.hook.PlaceholderUtil;
import cn.handyplus.warp.lib.InitApi;
import cn.handyplus.warp.lib.db.SqlManagerUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpTaskUtil;
import com.onarandombox.MultiverseCore.MultiverseCore;
import net.milkbowl.vault.economy.Economy;
import org.black_ixx.playerpoints.PlayerPoints;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerWarp
extends JavaPlugin {
    private static PlayerWarp INSTANCE;
    public static boolean USE_PAPI;
    public static Economy ECON;
    public static PlayerPoints PLAYER_POINTS;
    public static MultiverseCore MULTIVERSE_CORE;

    public void onEnable() {
        INSTANCE = this;
        InitApi initApi = InitApi.getInstance(this);
        ConfigUtil.init();
        USE_PAPI = BaseUtil.hook("PlaceholderAPI", "placeholderAPISucceedMsg", "placeholderAPIFailureMsg");
        if (USE_PAPI) {
            new PlaceholderUtil(this).register();
        }
        this.loadEconomy();
        this.loadPlayerPoints();
        this.loadMultiverseCore();
        initApi.initCommand("cn.handyplus.warp.command").initListener("cn.handyplus.warp.listener").enableSql("cn.handyplus.warp.enter").initClickEvent("cn.handyplus.warp.listener.gui").addMetrics(15977).enableBc().checkVersion(ConfigUtil.CONFIG.getBoolean("isCheckUpdate"), "https://api.github.com/repos/handy-git/PlayerWarp/releases/latest");
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u5df2\u6210\u529f\u8f7d\u5165\u670d\u52a1\u5668\uff01");
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "Author:handy MCBBS: https://www.mcbbs.net/thread-1369714-1-1.html");
        WarpTaskUtil.clearThermalValue();
        WarpPlayerService.getInstance().updateExpirationTime();
    }

    public void onDisable() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            InventoryView openInventory = onlinePlayer.getOpenInventory();
            InventoryHolder holder = openInventory.getTopInventory().getHolder();
            if (!(holder instanceof HandyInventory)) continue;
            onlinePlayer.closeInventory();
        }
        SqlManagerUtil.getInstance().close();
    }

    public static PlayerWarp getInstance() {
        return INSTANCE;
    }

    public static Economy getEconomy() {
        return ECON;
    }

    public static PlayerPoints getPlayerPoints() {
        return PLAYER_POINTS;
    }

    public void loadEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultFailureMsg"));
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultFailureMsg"));
            return;
        }
        ECON = (Economy)rsp.getProvider();
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultSucceedMsg"));
    }

    private void loadPlayerPoints() {
        if (Bukkit.getPluginManager().getPlugin("PlayerPoints") != null) {
            Plugin plugin = this.getServer().getPluginManager().getPlugin("PlayerPoints");
            PLAYER_POINTS = (PlayerPoints)plugin;
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("playerPointsSucceedMsg"));
            return;
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("playerPointsFailureMsg"));
    }

    public void loadMultiverseCore() {
        MULTIVERSE_CORE = (MultiverseCore)Bukkit.getPluginManager().getPlugin("Multiverse-Core");
        if (MULTIVERSE_CORE != null) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("multiverseCoreSucceedMsg"));
        } else {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("multiverseCoreFailureMsg"));
        }
    }
}

