/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.core;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LockUtil {
    private static final ConcurrentHashMap<String, AtomicInteger> STRING_LOCK_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, AtomicInteger> UUID_LOCK_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Long> UUID_TIME_LOCK_MAP = new ConcurrentHashMap();
    private static final Integer LOCK_TIME = 500;

    private LockUtil() {
    }

    public static AtomicInteger lock(String key) {
        if (STRING_LOCK_MAP.get(key) == null) {
            STRING_LOCK_MAP.putIfAbsent(key, new AtomicInteger(0));
        }
        STRING_LOCK_MAP.get(key).incrementAndGet();
        return STRING_LOCK_MAP.get(key);
    }

    public static void unLock(String key) {
        int source;
        if (STRING_LOCK_MAP.get(key) != null && (source = STRING_LOCK_MAP.get(key).decrementAndGet()) <= 0) {
            STRING_LOCK_MAP.remove(key);
        }
    }

    public static AtomicInteger lock(UUID key) {
        if (UUID_LOCK_MAP.get(key) == null) {
            UUID_LOCK_MAP.putIfAbsent(key, new AtomicInteger(0));
        }
        UUID_LOCK_MAP.get(key).incrementAndGet();
        return UUID_LOCK_MAP.get(key);
    }

    public static void unLock(UUID key) {
        int source;
        if (UUID_LOCK_MAP.get(key) != null && (source = UUID_LOCK_MAP.get(key).decrementAndGet()) <= 0) {
            UUID_LOCK_MAP.remove(key);
        }
    }

    public static boolean timeLock(UUID key) {
        Long time = UUID_TIME_LOCK_MAP.get(key);
        long currentTimeMillis = System.currentTimeMillis();
        if (time == null) {
            UUID_TIME_LOCK_MAP.putIfAbsent(key, System.currentTimeMillis());
            return true;
        }
        if (currentTimeMillis - time < (long)LOCK_TIME.intValue()) {
            return false;
        }
        UUID_TIME_LOCK_MAP.put(key, currentTimeMillis);
        return true;
    }

    public static void unTimeLock(UUID key) {
        UUID_TIME_LOCK_MAP.remove(key);
    }
}

