/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.core;

import cn.handyplus.warp.lib.constants.BaseConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class StrUtil {
    private StrUtil() {
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StrUtil.isEmpty(str);
    }

    public static String toLowerCase(String str) {
        return str != null ? str.toLowerCase() : null;
    }

    public static String replaceSpace(String str) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        return str.replace("#", " ");
    }

    public static List<String> strToStrList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (StrUtil.isEmpty(str)) {
            return list;
        }
        return Arrays.stream(str.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static List<Long> strToLongList(String str) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (StrUtil.isEmpty(str)) {
            return list;
        }
        return Arrays.stream(str.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
    }

    public static List<Integer> strToIntList(String str) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (StrUtil.isEmpty(str)) {
            return list;
        }
        return Arrays.stream(str.split(",")).map(s -> Integer.valueOf(s.trim())).collect(Collectors.toList());
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = BaseConstants.LINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String humpToLine(String str) {
        Matcher matcher = BaseConstants.HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String deleteWhitespace(String str) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static String replace(String str, String format, String value) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(format)) {
            return str;
        }
        return str.replace("${" + format + "}", value);
    }
}

