/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.listener;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.enter.WarpChannel;
import cn.handyplus.warp.lib.annotation.HandyListener;
import cn.handyplus.warp.lib.util.HandyHttpUtil;
import cn.handyplus.warp.service.WarpChannelService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpUtil;
import java.util.Optional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@HandyListener
public class PlayerJoinEventListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(final PlayerJoinEvent event) {
        new BukkitRunnable(){

            public void run() {
                String serverName = ConfigUtil.CONFIG.getString("serverName");
                Optional<WarpChannel> warpChannelOptional = WarpChannelService.getInstance().findByPlayerNameAndServerName(event.getPlayer().getName(), serverName);
                if (!warpChannelOptional.isPresent()) {
                    return;
                }
                WarpChannel warpChannel = warpChannelOptional.get();
                WarpChannelService.getInstance().delById(warpChannel.getId());
                WarpUtil.runTaskTpLocalWarpLocation(event.getPlayer(), warpChannel.getWarpName(), warpChannel.getWarpLocation());
            }
        }.runTaskLaterAsynchronously((Plugin)PlayerWarp.getInstance(), 20L);
    }

    @EventHandler
    public void onOpPlayerJoin(PlayerJoinEvent event) {
        if (!ConfigUtil.CONFIG.getBoolean("isCheckUpdateToOpMsg")) {
            return;
        }
        HandyHttpUtil.checkVersion(event.getPlayer(), "https://api.github.com/repos/handy-git/PlayerWarp/releases/latest");
    }
}

