/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;

public class WatcherValue {
    private final MetaIndex metaIndex;
    private final int index;
    private Object value;

    public WatcherValue(int index, Object value) {
        this.metaIndex = null;
        this.index = index;
        this.value = value;
    }

    public WatcherValue(MetaIndex index, Object value) {
        this.index = index.getIndex();
        this.metaIndex = index;
        this.value = value;
    }

    public WatcherValue(FlagWatcher flagWatcher, WrappedDataValue dataValue) {
        this.index = dataValue.getIndex();
        this.metaIndex = MetaIndex.getMetaIndex(flagWatcher, dataValue.getIndex());
        this.value = dataValue.getRawValue();
    }

    public WatcherValue(FlagWatcher flagWatcher, WrappedWatchableObject dataValue) {
        this.index = dataValue.getIndex();
        this.metaIndex = MetaIndex.getMetaIndex(flagWatcher, dataValue.getIndex());
        this.value = dataValue.getRawValue();
    }

    public WrappedWatchableObject getWatchableObject() {
        return ReflectionManager.createWatchable(this.getMetaIndex(), this.getValue());
    }

    public WrappedDataValue getDataValue() {
        return new WrappedDataValue(this.getMetaIndex().getIndex(), this.getMetaIndex().getSerializer(), ReflectionManager.convertInvalidMeta(this.getValue()));
    }

    public static List<WatcherValue> getValues(WrappedDataWatcher dataWatcher) {
        ArrayList<WatcherValue> list = new ArrayList<WatcherValue>();
        for (WrappedWatchableObject object : dataWatcher.getWatchableObjects()) {
            list.add(new WatcherValue(object.getIndex(), object.getRawValue()));
        }
        return list;
    }

    public static List<WatcherValue> getValues(FlagWatcher watcher, WrappedDataWatcher dataWatcher) {
        ArrayList<WatcherValue> newList = new ArrayList<WatcherValue>();
        for (WrappedWatchableObject object : dataWatcher.getWatchableObjects()) {
            newList.add(new WatcherValue(watcher, object));
        }
        return newList;
    }

    public static List<WatcherValue> getValues(FlagWatcher watcher, PacketContainer packetContainer) {
        ArrayList<WatcherValue> newList = new ArrayList<WatcherValue>();
        if (NmsVersion.v1_19_R2.isSupported()) {
            for (WrappedDataValue dataValue : (List)packetContainer.getDataValueCollectionModifier().read(0)) {
                newList.add(new WatcherValue(watcher, dataValue));
            }
        } else {
            for (WrappedWatchableObject object : (List)packetContainer.getWatchableCollectionModifier().read(0)) {
                newList.add(new WatcherValue(watcher, object));
            }
        }
        return newList;
    }

    public MetaIndex getMetaIndex() {
        return this.metaIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

