/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.animatorstands;

import com.gmail.berndivader.animatorstands.AnimatorStands;
import com.gmail.berndivader.animatorstands.ArmorStandAnimator;
import java.util.Iterator;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimatorClock {
    public AnimatorClock() {
        new BukkitRunnable(){
            private long cleanUpTick = 600L;
            private long currentCleanUpTick = 0L;
            private long aiClock = 0L;
            private long currentAiTick = 0L;

            public void run() {
                ++this.currentCleanUpTick;
                ++this.currentAiTick;
                for (ArmorStandAnimator asa : ArmorStandAnimator.getAnimators()) {
                    ++asa.currentAnimTick;
                    if (asa.currentAnimTick >= asa.AnimClock) {
                        this.animClock(asa);
                        asa.currentAnimTick = 0;
                    }
                    if (this.currentAiTick < this.aiClock) continue;
                    this.aiClock(asa);
                }
                if (this.currentCleanUpTick >= this.cleanUpTick) {
                    this.cleanUpClock();
                }
                if (this.currentAiTick >= this.aiClock) {
                    this.currentAiTick = 0L;
                }
            }

            private void cleanUpClock() {
                this.currentCleanUpTick = 0L;
                new BukkitRunnable(){

                    public void run() {
                        Iterator<ArmorStandAnimator> it = ArmorStandAnimator.getAnimators().iterator();
                        while (it.hasNext()) {
                            ArmorStandAnimator asa = it.next();
                            if (asa != null) {
                                if (asa.getArmorStand() != null && !asa.getArmorStand().isDead()) continue;
                                if (asa.hasAI()) {
                                    asa.aiMob.setDead();
                                }
                                it.remove();
                                continue;
                            }
                            it.remove();
                        }
                    }
                }.runTaskAsynchronously(AnimatorStands.inst());
            }

            private void aiClock(ArmorStandAnimator asa) {
                if (!asa.hasAI()) {
                    return;
                }
                ArmorStandAnimator.doAI(asa);
            }

            private void animClock(ArmorStandAnimator asa) {
                asa.update();
            }
        }.runTaskTimer(AnimatorStands.inst(), 1L, 1L);
    }
}

