/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.animatorstands;

import com.gmail.berndivader.animatorstands.AbstractTriggeredSkill;
import com.gmail.berndivader.animatorstands.AnimatorStands;
import com.gmail.berndivader.animatorstands.ArmorStandAnimator;
import com.gmail.berndivader.animatorstands.ArmorStandUtils;
import com.gmail.berndivader.animatorstands.conditions.ArmorStandIsAnimator;
import com.gmail.berndivader.animatorstands.conditions.ArmorStandPauseCondition;
import com.gmail.berndivader.animatorstands.conditions.ArmorStandaiMobTargetDistance;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandChangeAnimMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandInitMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandLookAtMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandPauseMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandRunMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandUnloadMechanic;
import com.gmail.berndivader.animatorstands.targeters.AiMobTargeter;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicConditionLoadEvent;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobDeathEvent;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicTargeterLoadEvent;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public class MythicMobsEvents
implements Listener {
    public MythicMobsEvents() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, AnimatorStands.inst());
    }

    @EventHandler
    public void mmMythicMobsMechanicsLoad(MythicMechanicLoadEvent e) {
        String m;
        switch (m = e.getMechanicName().toLowerCase()) {
            case "asinit": {
                ArmorStandInitMechanic skill = new ArmorStandInitMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "asunload": {
                ArmorStandUnloadMechanic skill = new ArmorStandUnloadMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "aspause": {
                ArmorStandPauseMechanic skill = new ArmorStandPauseMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "asrun": {
                ArmorStandRunMechanic skill = new ArmorStandRunMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "aschange": {
                ArmorStandChangeAnimMechanic skill = new ArmorStandChangeAnimMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "aslookat": {
                ArmorStandLookAtMechanic skill = new ArmorStandLookAtMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
        }
    }

    @EventHandler
    public void mmMythicMobsConditionsLoad(MythicConditionLoadEvent e) {
        String c;
        switch (c = e.getConditionName().toLowerCase()) {
            case "animatestandpaused": {
                ArmorStandPauseCondition condition = new ArmorStandPauseCondition(c, e.getConfig());
                e.register((SkillCondition)condition);
                break;
            }
            case "isanimatestand": {
                ArmorStandIsAnimator condition = new ArmorStandIsAnimator(c, e.getConfig());
                e.register((SkillCondition)condition);
                break;
            }
            case "aimobtargetdistance": {
                ArmorStandaiMobTargetDistance condition = new ArmorStandaiMobTargetDistance(c, e.getConfig());
                e.register((SkillCondition)condition);
                break;
            }
        }
    }

    @EventHandler
    public void MythicMobTargeterLoad(MythicTargeterLoadEvent e) {
        if (e.getTargeterName().toLowerCase().equals("aitarget")) {
            e.register((SkillTargeter)new AiMobTargeter(e.getConfig()));
        }
    }

    @EventHandler
    public void mmAiMobDeath(MythicMobDeathEvent e) {
        if (!e.getEntity().hasMetadata("aiMob")) {
            return;
        }
        UUID u = this.getUUIDbyMeta(e.getEntity());
        ActiveMob am = (ActiveMob)MythicMobs.inst().getMobManager().getActiveMob(u).get();
        am.setDead();
        am.signalMob(BukkitAdapter.adapt((Entity)e.getKiller()), "DEATH");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void mmAiMobDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent ed = (EntityDamageByEntityEvent)e;
            UUID u = null;
            if (ed.getDamager().hasMetadata("aiMob")) {
                ed.setCancelled(true);
                u = this.getUUIDbyMeta(ed.getDamager());
                if (MythicMobs.inst().getMobManager().isActiveMob(u)) {
                    ActiveMob am = (ActiveMob)MythicMobs.inst().getMobManager().getActiveMob(u).get();
                    am.setTarget(BukkitAdapter.adapt((Entity)e.getEntity()));
                    new AbstractTriggeredSkill(SkillTrigger.ATTACK, am, BukkitAdapter.adapt((Entity)e.getEntity()));
                }
                return;
            }
            if (e.getEntity().hasMetadata("aiMob")) {
                u = this.getUUIDbyMeta(e.getEntity());
                if (MythicMobs.inst().getMobManager().isActiveMob(u)) {
                    ActiveMob am = (ActiveMob)MythicMobs.inst().getMobManager().getActiveMob(u).get();
                    AbstractEntity damager = this.getAttacker(ed.getDamager());
                    am.setLastAggroCause(damager);
                    new AbstractTriggeredSkill(SkillTrigger.DAMAGED, am, damager);
                }
                return;
            }
        } else if (e.getEntity().hasMetadata("aiMob")) {
            UUID u = this.getUUIDbyMeta(e.getEntity());
            if (MythicMobs.inst().getMobManager().isActiveMob(u)) {
                ActiveMob am = (ActiveMob)MythicMobs.inst().getMobManager().getActiveMob(u).get();
                new AbstractTriggeredSkill(SkillTrigger.DAMAGED, am, null);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimatorStandHandleDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getEntity().getType().equals((Object)EntityType.ARMOR_STAND) && e.getEntity().hasMetadata("asa")) {
            EntityDamageByEntityEvent ee;
            AbstractEntity attacker;
            ArmorStandAnimator asa = ArmorStandUtils.getAnimatorInstance(BukkitAdapter.adapt((Entity)e.getEntity()));
            if (!asa.hasAI()) {
                return;
            }
            e.setCancelled(true);
            if (e instanceof EntityDamageByEntityEvent && !asa.isDying && !(attacker = this.getAttacker((ee = (EntityDamageByEntityEvent)e).getDamager())).isPlayer()) {
                LivingEntity entity = (LivingEntity)asa.aiMob.getEntity().getBukkitEntity();
                entity.damage(e.getDamage(), ee.getDamager());
            }
        }
    }

    @EventHandler
    public void onInteractTrigger(PlayerInteractAtEntityEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Entity l = e.getRightClicked();
        if (l.hasMetadata("aiMob")) {
            ActiveMob am;
            AbstractTriggeredSkill ts;
            UUID u = this.getUUIDbyMeta(l);
            if (MythicMobs.inst().getMobManager().isActiveMob(u) && (ts = new AbstractTriggeredSkill(SkillTrigger.INTERACT, am = (ActiveMob)MythicMobs.inst().getMobManager().getActiveMob(u).get(), (AbstractEntity)BukkitAdapter.adapt((Player)e.getPlayer()), null, true)).getCancelled()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void mmaiMobDeathEvent(MythicMobDeathEvent e) {
        if (e.getEntity().hasMetadata("aiMob")) {
            UUID u = this.getUUIDbyMeta(e.getEntity());
            if (MythicMobs.inst().getMobManager().isActiveMob(u)) {
                ActiveMob am = (ActiveMob)MythicMobs.inst().getMobManager().getActiveMob(u).get();
                AbstractEntity killer = BukkitAdapter.adapt((Entity)e.getKiller());
                am.setLastAggroCause(killer);
                new AbstractTriggeredSkill(SkillTrigger.DEATH, am, killer);
                final ArmorStandAnimator asa = ArmorStandUtils.getAnimatorInstance(am.getEntity());
                asa.isDying = true;
                new BukkitRunnable(){

                    public void run() {
                        if (asa != null) {
                            asa.getArmorStand().remove();
                            asa.stop();
                            asa.remove();
                        }
                    }
                }.runTaskLater(AnimatorStands.inst(), 20L);
            }
        }
    }

    private AbstractEntity getAttacker(Entity damager) {
        if (damager instanceof Projectile) {
            if (((Projectile)damager).getShooter() instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)((Projectile)damager).getShooter();
                if (shooter != null && shooter instanceof LivingEntity) {
                    return BukkitAdapter.adapt((Entity)shooter);
                }
            } else {
                return null;
            }
        }
        if (damager instanceof LivingEntity) {
            return BukkitAdapter.adapt((Entity)damager);
        }
        return null;
    }

    private UUID getUUIDbyMeta(Entity e) {
        String u1 = ((MetadataValue)e.getMetadata("aiMob").get(0)).asString();
        String u2 = ((MetadataValue)e.getMetadata("aiMob1").get(0)).asString();
        return UUID.fromString(u1 + u2);
    }
}

