/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.commands;

import io.lumine.artifacts.Artifacts;
import io.lumine.xikage.mythicmobs.commands.CommandHelper;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class EnchantCommand
extends Command<Artifacts> {
    public EnchantCommand(Command<Artifacts> parent) {
        super(parent);
    }

    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            CommandHelper.sendError((CommandSender)sender, (String)"Command Syntax: /ma enchant <enchantment> [level]");
            return true;
        }
        Player target = (Player)sender;
        String strEnchant = args[0];
        int level = 1;
        if (args.length > 1) {
            level = Integer.valueOf(args[1]);
        }
        if (target == null) {
            CommandHelper.sendError((CommandSender)sender, (String)"That player is not online");
            return true;
        }
        ItemStack item = target.getInventory().getItemInHand();
        if (!Artifacts.inst().getEnchantManager().isRegistered(strEnchant)) {
            CommandHelper.sendError((CommandSender)sender, (String)"Enchantment doesnt exist");
            return true;
        }
        Artifacts.inst().getEnchantManager().applyEnchantment(item, strEnchant, level);
        Artifacts.inst().getProfileManager().getPlayerProfile(target).parseWeapons();
        CommandHelper.sendSuccess((CommandSender)sender, (String)"Enchantment applied to item.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], Artifacts.inst().getEnchantManager().getEnchantmentNames(), new ArrayList());
        }
        return null;
    }

    public String getPermissionNode() {
        return "mythicartifacts.command.enchant";
    }

    public boolean isConsoleFriendly() {
        return false;
    }

    public String getName() {
        return "enchant";
    }

    public String[] getAliases() {
        return new String[]{"e"};
    }
}

