/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.commands;

import io.lumine.artifacts.Artifacts;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.commands.CommandHelper;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class GiveCommand
extends Command<Artifacts> {
    public GiveCommand(Command<Artifacts> parent) {
        super(parent);
    }

    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            CommandHelper.sendError((CommandSender)sender, (String)"Command Syntax: /mm item give <name> <item>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        String item = args[1];
        int amount = 1;
        if (args.length > 2) {
            amount = Integer.valueOf(args[2]);
        }
        if (target == null) {
            CommandHelper.sendError((CommandSender)sender, (String)"That player is not online");
            return true;
        }
        Optional maybeItem = MythicMobs.inst().getItemManager().getItem(item);
        if (maybeItem.isPresent()) {
            MythicItem mi = (MythicItem)maybeItem.get();
            for (int i = 0; i < amount; ++i) {
                target.getInventory().addItem(new ItemStack[]{BukkitAdapter.adapt((AbstractItemStack)mi.generateItemStack(1, (AbstractEntity)BukkitAdapter.adapt((Player)target), (AbstractEntity)BukkitAdapter.adapt((Player)target)))});
            }
            target.sendMessage(ChatColor.GOLD + "[MythicArtifacts] " + ChatColor.GREEN + "Item " + ChatColor.AQUA + item + ChatColor.GREEN + " was put in your inventory!");
            sender.sendMessage("");
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicArtifacts] " + ChatColor.RED + "No Mythic Item loaded with the name " + item + ".");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                players.add(p.getName());
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], players, new ArrayList());
        }
        if (args.length == 2) {
            return (List)StringUtil.copyPartialMatches((String)args[1], ((Artifacts)this.getPlugin()).getItemManager().getItemNames(), new ArrayList());
        }
        return null;
    }

    public String getPermissionNode() {
        return "mythicartifacts.command.give";
    }

    public boolean isConsoleFriendly() {
        return true;
    }

    public String getName() {
        return "give";
    }

    public String[] getAliases() {
        return new String[]{"g", "gi"};
    }
}

