/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.enchants;

import com.google.common.io.Files;
import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.enchants.MythicEnchantment;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicReloadedEvent;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableRegistry;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersion;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class EnchantManager
implements Terminable {
    private final MythicMobs mythicMobs;
    private final Artifacts core;
    private List<File> enchantmentFiles;
    private IOLoader<MythicMobs> defaultEnchantments;
    private List<IOLoader<MythicMobs>> enchantmentLoaders;
    private ConcurrentHashMap<String, MythicEnchantment> enchantments = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MythicEnchantment> enchantmentsDisplay = new ConcurrentHashMap();
    private List<Runnable> secondPass = new ArrayList<Runnable>();
    private TerminableRegistry components = TerminableRegistry.create();

    public EnchantManager(Artifacts core) {
        this.mythicMobs = MythicMobs.inst();
        this.core = core;
        if (core.getConfiguration().getUseEnchantments().booleanValue()) {
            if (ServerVersion.isBefore((MinecraftVersion)MinecraftVersions.v1_13)) {
                Artifacts.error("Custom Enchantments are only available on 1.13+");
                return;
            }
            this.start();
        }
    }

    public boolean start() {
        this.components.accept((Object)Events.subscribe(MythicReloadedEvent.class).handler(event1 -> this.loadEnchantments()));
        this.components.accept((Object)Events.subscribe(EnchantItemEvent.class).handler(event2 -> {
            for (Map.Entry enchant : event2.getEnchantsToAdd().entrySet()) {
                if (!(enchant.getKey() instanceof MythicEnchantment)) continue;
                ((MythicEnchantment)((Object)((Object)enchant.getKey()))).applyToItem(event2.getItem(), (Integer)enchant.getValue());
            }
        }));
        this.components.accept((Object)Events.subscribe(EnchantItemEvent.class).handler(event3 -> {
            for (Map.Entry enchant : event3.getEnchantsToAdd().entrySet()) {
                if (!(enchant.getKey() instanceof MythicEnchantment)) continue;
                ((MythicEnchantment)((Object)((Object)enchant.getKey()))).applyToItem(event3.getItem(), (Integer)enchant.getValue());
            }
        }));
        this.components.accept((Object)Events.subscribe(PrepareAnvilEvent.class).handler(event4 -> this.handleAnvilEvent((PrepareAnvilEvent)event4)));
        this.loadEnchantments();
        return true;
    }

    public boolean reload() {
        this.terminate();
        if (this.core.getConfiguration().getUseEnchantments().booleanValue()) {
            if (ServerVersion.isBefore((MinecraftVersion)MinecraftVersions.v1_13)) {
                Artifacts.error("Custom Enchantments are only available on 1.13+");
                return false;
            }
            this.start();
        }
        return false;
    }

    public void close() {
        this.components.terminate();
    }

    public void loadEnchantments() {
        String exampleFileName = "ExampleEnchantments.yml";
        this.core.saveResource("ExampleEnchantments.yml", true);
        File tempFile = new File(this.core.getDataFolder() + File.separator + "ExampleEnchantments.yml");
        File tempFileM = new File(this.mythicMobs.getDataFolder() + File.separator + "Enchantments" + File.separator + "ExampleEnchantments.yml");
        File tempDir = new File(this.mythicMobs.getDataFolder() + File.separator + "Enchantments");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        if (!tempFileM.exists()) {
            try {
                Files.copy((File)tempFile, (File)tempFileM);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.defaultEnchantments = new IOLoader((JavaPlugin)MythicMobs.inst(), tempFile, "Enchantments");
        this.enchantmentFiles = IOHandler.getAllFiles((String)(this.mythicMobs.getDataFolder() + File.separator + "Enchantments"));
        File packsFolder = new File(this.mythicMobs.getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "Enchantments")).exists() || !confFolder.isDirectory()) continue;
                this.enchantmentFiles.addAll(IOHandler.getAllFiles((String)confFolder.getAbsolutePath()));
            }
        }
        this.enchantmentLoaders = IOHandler.getSaveLoad((JavaPlugin)MythicMobs.inst(), this.enchantmentFiles, (String)"Enchantments");
        this.enchantmentsDisplay.clear();
        for (IOLoader iOLoader : this.enchantmentLoaders) {
            for (String name : iOLoader.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicEnchantment ms;
                String file = iOLoader.getFile().getPath();
                MythicConfig mc = new MythicConfig(name, iOLoader.getCustomConfig());
                if (!this.enchantments.containsKey(name.toUpperCase())) {
                    ms = new MythicEnchantment(file, name, mc);
                    this.enchantments.put(name, ms);
                    this.enchantments.put(name.toUpperCase(), ms);
                    this.enchantments.put(ms.getName(), ms);
                    this.enchantmentsDisplay.put(name.toUpperCase(), ms);
                    continue;
                }
                ms = this.enchantments.get(name.toUpperCase());
                ms.setup(mc);
                this.enchantmentsDisplay.put(ms.getName(), ms);
            }
        }
        this.runSecondPass();
    }

    public void runSecondPass() {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Doing second pass on " + this.secondPass.size() + " enchantments."), (Object[])new Object[0]);
        this.secondPass.forEach(r -> r.run());
        this.secondPass.clear();
    }

    public void queueSecondPass(Runnable r) {
        this.secondPass.add(r);
    }

    public boolean isRegistered(String enchantmentName) {
        return this.enchantments.containsKey(enchantmentName);
    }

    public Collection<String> getEnchantmentNames() {
        return this.enchantments.keySet();
    }

    public Collection<String> getEnchantmentDisplayNames() {
        return this.enchantmentsDisplay.keySet();
    }

    public Map<MythicEnchantment, Integer> getMythicEnchants(ItemStack item) {
        HashMap<MythicEnchantment, Integer> map = new HashMap<MythicEnchantment, Integer>();
        if (item != null && item.getEnchantments() != null) {
            item.getEnchantments().forEach((enchant, level) -> {
                if (enchant instanceof MythicEnchantment) {
                    map.put((MythicEnchantment)((Object)enchant), (Integer)level);
                }
            });
        }
        return map;
    }

    public void applyEnchantment(ItemStack item, String strEnchant, int level) {
        this.enchantments.get(strEnchant.toUpperCase()).applyToItem(item, level);
    }

    private void handleAnvilEvent(PrepareAnvilEvent theevent) {
        ItemStack first = theevent.getInventory().getItem(0);
        ItemStack second = theevent.getInventory().getItem(1);
        Object result = EnchantManager.isPresent(theevent.getResult()) ? theevent.getResult() : (this.isSingle(first) && this.isSingle(second) ? this.select(first, second, true).clone() : null);
        if (!EnchantManager.isPresent(result) || !this.isBook(first) && !this.isBook(second) && !first.getType().equals((Object)second.getType())) {
            return;
        }
        Map<MythicEnchantment, Integer> enchantsF = this.getMythicEnchants(first);
        Map<MythicEnchantment, Integer> enchantsS = this.getMythicEnchants(second);
        enchantsS.forEach((enchant, level) -> enchantsF.merge((MythicEnchantment)((Object)enchant), (Integer)level, (i, j) -> i == j ? Math.min(enchant.getMaxLevel(), i + 1) : Math.max(i, j)));
        if (enchantsF.size() == 0) {
            return;
        }
        this.getMythicEnchants(this.select(first, second, true)).forEach((arg_0, arg_1) -> EnchantManager.lambda$handleAnvilEvent$8((ItemStack)result, arg_0, arg_1));
        int mergeCost = 0;
        for (Map.Entry<MythicEnchantment, Integer> entry : enchantsF.entrySet()) {
            MythicEnchantment enchant2 = entry.getKey();
            int level2 = entry.getValue();
            if (enchant2.getEnchantableMaterials().size() > 0 && !enchant2.getEnchantableMaterials().contains(result.getType())) {
                theevent.setResult(null);
                theevent.getInventory().setRepairCost(9999);
                return;
            }
            if (enchant2.getConflictingEnchants().size() > 0) {
                boolean b = false;
                for (Enchantment ench : result.getEnchantments().keySet()) {
                    if (!enchant2.getConflictingEnchants().contains(ench.getName().toUpperCase())) continue;
                    b = true;
                }
                if (b) {
                    theevent.setResult(null);
                    theevent.getInventory().setRepairCost(9999);
                    return;
                }
            }
            enchant2.applyToItem((ItemStack)result, level2);
            mergeCost += enchant2.getMergeCostPerLevel() * level2;
        }
        int fMergeCost = theevent.getInventory().getRepairCost() + mergeCost;
        theevent.setResult(result);
        theevent.getInventory().setRepairCost(fMergeCost);
        Schedulers.sync().runLater(() -> EnchantManager.lambda$handleAnvilEvent$9(theevent, (ItemStack)result, fMergeCost), 1L);
    }

    private ItemStack select(ItemStack first, ItemStack second, boolean result) {
        return (!this.isBook(first) || this.isBook(second)) == result ? first : second;
    }

    private boolean isBook(ItemStack item) {
        return !EnchantManager.isPresent(item) || item.getType() == Material.BOOK || item.getType() == Material.ENCHANTED_BOOK;
    }

    private boolean isSingle(ItemStack item) {
        return EnchantManager.isPresent(item) && item.getAmount() == 1;
    }

    public static boolean isPresent(ItemStack item) {
        return item != null && item.getType() != Material.AIR;
    }

    private static /* synthetic */ void lambda$handleAnvilEvent$9(PrepareAnvilEvent theevent, ItemStack result, int fMergeCost) {
        theevent.setResult(result);
        theevent.getInventory().setRepairCost(fMergeCost);
    }

    private static /* synthetic */ void lambda$handleAnvilEvent$8(ItemStack result, MythicEnchantment enchant, Integer level) {
        enchant.removeLore(result, level);
    }
}

