/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.enchants;

import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.util.LoreParser;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillManager;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.utils.reflection.Reflector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MythicEnchantment
extends Enchantment {
    private static Reflector<Enchantment> refEnchantment = new Reflector(Enchantment.class, new String[]{"acceptingNew"});
    private final String internalName;
    private final String fileName;
    private String name;
    private MythicConfig config;
    private int startLevel;
    private int maxLevel;
    EnchantmentTarget itemTarget;
    private boolean cursed;
    private boolean treasure;
    private int mergeCostPerLevel;
    private List<Material> enchantableMaterials = new ArrayList<Material>();
    private List<String> conflictingEnchants = new ArrayList<String>();
    private Map<SkillTrigger, Queue<SkillMechanic>> mechanics = new HashMap<SkillTrigger, Queue<SkillMechanic>>();
    private Queue<SkillMechanic> timerMechanics = null;

    private static Artifacts getPlugin() {
        return Artifacts.inst();
    }

    public MythicEnchantment(String file, String name, MythicConfig mc) {
        super(new NamespacedKey((Plugin)MythicEnchantment.getPlugin(), name.toUpperCase()));
        this.fileName = file;
        this.internalName = name;
        this.setup(mc);
        this.register();
    }

    public void setup(MythicConfig mc) {
        this.config = mc;
        this.name = mc.getString("Display");
        this.startLevel = mc.getInteger("StartLevel", 1);
        this.maxLevel = mc.getInteger("MaxLevel", 5);
        try {
            String strItemTarget = mc.getString("ItemType", "ALL");
            this.itemTarget = EnchantmentTarget.valueOf((String)strItemTarget.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.error((String)"Invalid EnchantmentTarget specified for custom enchantment {0}", (Object[])new Object[]{this.internalName});
            this.itemTarget = EnchantmentTarget.ALL;
        }
        this.cursed = mc.getBoolean("Options.Cursed", false);
        this.treasure = mc.getBoolean("Options.Treasure", false);
        this.mergeCostPerLevel = mc.getInteger("MergeCost", 2);
        List enchantables = mc.getStringList("EnchantableItems");
        this.enchantableMaterials.clear();
        for (Object string : enchantables) {
            try {
                Material mat = Material.valueOf((String)((String)string).toUpperCase());
                this.enchantableMaterials.add(mat);
            }
            catch (Exception mat) {}
        }
        List conflicting = mc.getStringList("ConflictingEnchants");
        this.conflictingEnchants.clear();
        for (String string : conflicting) {
            this.conflictingEnchants.add(string.toUpperCase());
        }
        this.mechanics.clear();
        this.timerMechanics = null;
        SkillManager sm = MythicMobs.inst().getSkillManager();
        List skills = mc.getStringList("Skills");
        for (String s : skills) {
            Matcher Rmatcher;
            Pattern Rpattern;
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Loading mechanic line: {0}", (Object[])new Object[]{s});
            s = MythicLineConfig.unparseBlock((String)s);
            SkillMechanic ms = MythicMobs.inst().getSkillManager().getSkillMechanic(s);
            int interval = 1;
            if (ms == null) continue;
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Base skill found.", (Object[])new Object[0]);
            if (s.contains("~onTimer")) {
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is Timer. Assigning skill to Timer...", (Object[])new Object[0]);
                Rpattern = Pattern.compile("~onTimer:([0-9]+)");
                Rmatcher = Rpattern.matcher(s);
                Rmatcher.find();
                try {
                    interval = Integer.parseInt(Rmatcher.group(1));
                }
                catch (Exception e) {
                    MythicLogger.error((String)("Error parsing Timer skill, invalid interval specified (must be an integer). AbstractSkill=" + s));
                    continue;
                }
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)("AbstractSkill set on timer with interval " + interval), (Object[])new Object[0]);
                ms.setTimerInterval(interval);
                if (this.timerMechanics == null) {
                    this.timerMechanics = new LinkedList<SkillMechanic>();
                }
                this.timerMechanics.add(ms);
                continue;
            }
            if (s.contains("~onSignal:")) {
                String signal;
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is Signal.", (Object[])new Object[0]);
                Rpattern = Pattern.compile("~onSignal:([a-zA-Z0-9_-]*)");
                Rmatcher = Rpattern.matcher(s);
                Rmatcher.find();
                try {
                    signal = Rmatcher.group(1);
                }
                catch (Exception e) {
                    MythicLogger.error((String)("Error parsing Signal skill, invalid signal specified (contains invalid characters). AbstractSkill=" + s));
                    continue;
                }
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)("AbstractSkill set on Signal with index " + signal), (Object[])new Object[0]);
                this.saveSkill(SkillTrigger.SIGNAL, ms);
                continue;
            }
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is NOT Timer. Assigning skill to regular skill tree...", (Object[])new Object[0]);
            this.saveSkill(ms.getTrigger(), ms);
        }
    }

    private void saveSkill(SkillTrigger trigger, SkillMechanic skill) {
        if (!this.mechanics.containsKey(trigger)) {
            this.mechanics.put(trigger, new LinkedList());
        }
        this.mechanics.get(trigger).add(skill);
    }

    private void register() {
        refEnchantment.set(null, "acceptingNew", (Object)true);
        Enchantment.registerEnchantment((Enchantment)this);
        refEnchantment.set(null, "acceptingNew", (Object)false);
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.enchantableMaterials.size() > 0 ? this.enchantableMaterials.contains(item.getType().toString()) : true;
    }

    public boolean conflictsWith(Enchantment enchant) {
        return this.conflictingEnchants.size() > 0 ? this.enchantableMaterials.contains(enchant.getName()) : false;
    }

    public ItemStack applyToItem(ItemStack item, int level) {
        if (item.getType() == Material.BOOK) {
            item.setType(Material.ENCHANTED_BOOK);
        }
        if (item.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item.getItemMeta();
            List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            int lvl = MythicEnchantment.getPlugin().getEnchantManager().getMythicEnchants(item).getOrDefault((Object)this, 0);
            if (lvl > 0) {
                lore.remove(LoreParser.formatEnchantment(this, lvl));
            }
            if (!item.getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
                lore.add(0, LoreParser.formatEnchantment(this, level));
            }
            meta.setLore(lore);
            meta.addStoredEnchant((Enchantment)this, level, true);
            item.setItemMeta((ItemMeta)meta);
        } else {
            ItemMeta meta = item.getItemMeta();
            List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            int lvl = MythicEnchantment.getPlugin().getEnchantManager().getMythicEnchants(item).getOrDefault((Object)this, 0);
            if (lvl > 0) {
                lore.remove(LoreParser.formatEnchantment(this, lvl));
            }
            if (!item.getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
                lore.add(0, LoreParser.formatEnchantment(this, level));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            item.addUnsafeEnchantment((Enchantment)this, level);
        }
        return item;
    }

    public ItemStack removeLore(ItemStack item, int level) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        lore.remove(LoreParser.formatEnchantment(this, level));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public boolean hasMechanics(SkillTrigger cause) {
        return this.mechanics.containsKey(cause);
    }

    public Queue<SkillMechanic> getMechanics(SkillTrigger cause) {
        return this.mechanics.get(cause);
    }

    public boolean hasTimerSkills() {
        return this.timerMechanics != null;
    }

    public Queue<SkillMechanic> getTimerSkills() {
        return this.timerMechanics;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public EnchantmentTarget getItemTarget() {
        return this.itemTarget;
    }

    public boolean isCursed() {
        return this.cursed;
    }

    public boolean isTreasure() {
        return this.treasure;
    }

    public int getMergeCostPerLevel() {
        return this.mergeCostPerLevel;
    }

    public List<Material> getEnchantableMaterials() {
        return this.enchantableMaterials;
    }

    public List<String> getConflictingEnchants() {
        return this.conflictingEnchants;
    }
}

