/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.items;

import io.lumine.artifacts.items.Artifact;
import io.lumine.artifacts.items.ItemManager;
import io.lumine.artifacts.profiles.Profile;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersion;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.List;
import java.util.regex.Matcher;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemAmmo {
    private final Profile profile;
    private final Artifact item;
    private Matcher loreMatcher;
    private int ammoCurrent;

    public ItemAmmo(Profile profile, Artifact item) {
        this.profile = profile;
        this.item = item;
        int loreLine = item.getAmmoLoreLine();
        ItemStack stack = BukkitAdapter.adapt((AbstractPlayer)profile.getPlayer()).getInventory().getItemInMainHand();
        ItemMeta meta = stack.getItemMeta();
        String ammoLine = (String)meta.getLore().get(loreLine);
        this.loreMatcher = ItemManager.AmmunitionRegex.matcher(ammoLine);
        if (this.loreMatcher.find()) {
            this.ammoCurrent = Integer.valueOf(this.loreMatcher.group(1));
        }
    }

    public boolean hasAmmo(int amount) {
        return this.ammoCurrent >= amount;
    }

    public boolean useAmmo(int amount) {
        if (this.hasAmmo(amount)) {
            this.ammoCurrent -= amount;
            this.updateLore();
            return true;
        }
        return false;
    }

    public int getMaxAmmo() {
        return this.item.getAmmoClipSize();
    }

    public boolean reload() {
        String ammoName = this.item.getAmmoType().get().getDisplayName();
        Player player = BukkitAdapter.adapt((AbstractPlayer)this.profile.getPlayer());
        int clip = this.item.getAmmoClipSize();
        int needed = (clip - this.ammoCurrent) / this.item.getAmmoPerItem();
        if (this.ammoCurrent == clip) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Ammo already full", (Object[])new Object[0]);
            return true;
        }
        int amount = 0;
        if (ServerVersion.isAfterOrEq((MinecraftVersion)MinecraftVersions.v1_13) && ammoName.startsWith("" + ChatColor.WHITE)) {
            ammoName = ammoName.substring(2);
        }
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack it = player.getInventory().getItem(i);
            if (it == null || !it.hasItemMeta() || it.getItemMeta().getDisplayName() == null || !it.getItemMeta().getDisplayName().equals(ammoName)) continue;
            if (it.getAmount() > needed) {
                amount = needed;
                it.setAmount(it.getAmount() - needed);
                break;
            }
            amount = it.getAmount();
            player.getInventory().setItem(i, new ItemStack(Material.AIR));
            break;
        }
        if (amount == 0) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"No ammo left", (Object[])new Object[0]);
            return false;
        }
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Ammo reloaded", (Object[])new Object[0]);
        this.ammoCurrent += amount * this.item.getAmmoPerItem();
        this.updateLore();
        return true;
    }

    public void updateLore() {
        int loreLine = this.item.getAmmoLoreLine();
        ItemStack stack = BukkitAdapter.adapt((AbstractPlayer)this.profile.getPlayer()).getInventory().getItemInMainHand();
        ItemMeta meta = stack.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            return;
        }
        String ammoLine = (String)meta.getLore().get(loreLine);
        this.loreMatcher = ItemManager.AmmunitionRegex.matcher(ammoLine);
        this.loreMatcher.find();
        ammoLine = this.loreMatcher.replaceAll("Ammunition " + this.ammoCurrent + " / " + this.item.getAmmoClipSize());
        List lore = meta.getLore();
        lore.set(loreLine, ammoLine);
        meta.setLore(lore);
        stack.setItemMeta(meta);
    }

    public int getCurrentAmmo() {
        return this.ammoCurrent;
    }
}

