/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.skills;

import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.profiles.Profile;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableRegistry;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class SkillManager
implements Terminable {
    private final Artifacts plugin;
    private TerminableRegistry components = TerminableRegistry.create();
    private Consumer<PlayerJoinEvent> TRIGGER_SPAWN_JOIN = event -> this.getProfile(event.getPlayer()).runSkills(SkillTrigger.SPAWN, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
    private Consumer<PlayerRespawnEvent> TRIGGER_SPAWN_RESPAWN = event -> this.getProfile(event.getPlayer()).runSkills(SkillTrigger.SPAWN, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
    private Consumer<PlayerToggleSneakEvent> TRIGGER_CROUCH = event -> {
        if (!event.getPlayer().isSneaking()) {
            this.getProfile(event.getPlayer()).runSkills(SkillTrigger.CROUCH, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
        } else {
            this.getProfile(event.getPlayer()).runSkills(SkillTrigger.UNCROUCH, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
        }
    };

    public SkillManager(Artifacts plugin) {
        this.plugin = plugin;
    }

    public boolean start() {
        this.components.accept((Object)Events.subscribe(PlayerJoinEvent.class).handler(this.TRIGGER_SPAWN_JOIN));
        this.components.accept((Object)Events.subscribe(PlayerRespawnEvent.class).handler(this.TRIGGER_SPAWN_RESPAWN));
        this.components.accept((Object)Events.subscribe(PlayerToggleSneakEvent.class).handler(this.TRIGGER_CROUCH));
        return true;
    }

    public void close() {
        this.components.terminate();
    }

    private Profile getProfile(Player player) {
        return this.plugin.getProfileManager().getPlayerProfile(player);
    }

    public Artifacts getPlugin() {
        return this.plugin;
    }
}

