/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters;

import io.lumine.xikage.mythicmobs.adapters.AbstractBiome;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.utils.serialize.Locus;
import io.lumine.xikage.mythicmobs.utils.serialize.Position;

public class AbstractLocation
implements Cloneable {
    private AbstractWorld world;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public AbstractLocation() {
    }

    public AbstractLocation(AbstractWorld world, double x, double y, double z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public AbstractLocation(AbstractWorld world, double x, double y, double z, float yaw, float pitch) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Position toPosition() {
        return Position.of(this.x, this.y, this.z, BukkitAdapter.adapt(this.world));
    }

    public Locus toLocus() {
        return Locus.of(this.x, this.y, this.z);
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockX() {
        return (int)this.x;
    }

    public int getBlockY() {
        return (int)this.y;
    }

    public int getBlockZ() {
        return (int)this.z;
    }

    public int getChunkX() {
        return this.getBlockX() / 16;
    }

    public int getChunkZ() {
        return this.getBlockZ() / 16;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public AbstractWorld getWorld() {
        return this.world;
    }

    public double distance(AbstractLocation t) throws IllegalArgumentException {
        return Math.sqrt(this.distanceSquared(t));
    }

    public double distanceSquared(AbstractLocation t) throws IllegalArgumentException {
        if (!t.getWorld().equals(this.world)) {
            throw new IllegalArgumentException("Cannot measure distance between two different worlds.");
        }
        return Math.pow(t.getX() - this.getX(), 2.0) + Math.pow(t.getY() - this.getY(), 2.0) + Math.pow(t.getZ() - this.getZ(), 2.0);
    }

    public double distance2D(AbstractLocation t) {
        return Math.sqrt(this.distance2DSquared(t));
    }

    public double distance2DSquared(AbstractLocation t) {
        if (!t.getWorld().equals(this.world)) {
            throw new IllegalArgumentException("Cannot measure distance between two different worlds.");
        }
        return Math.pow(t.getX() - this.getX(), 2.0) + Math.pow(t.getZ() - this.getZ(), 2.0);
    }

    public AbstractLocation add(double xA, double yA, double zA) {
        this.x += xA;
        this.y += yA;
        this.z += zA;
        return this;
    }

    public AbstractVector getDirection() {
        AbstractVector vector = new AbstractVector();
        double rotX = this.getYaw();
        double rotY = this.getPitch();
        vector.setY(-Math.sin(Math.toRadians(rotY)));
        double xz = Math.cos(Math.toRadians(rotY));
        vector.setX(-xz * Math.sin(Math.toRadians(rotX)));
        vector.setZ(xz * Math.cos(Math.toRadians(rotX)));
        return vector;
    }

    public AbstractLocation add(AbstractLocation vec) {
        if (vec == null || !vec.getWorld().equals(this.getWorld())) {
            throw new IllegalArgumentException("Cannot add Locations of differing worlds");
        }
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public AbstractLocation add(AbstractVector vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        this.z += vec.getZ();
        return this;
    }

    public AbstractLocation subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public AbstractLocation subtract(AbstractLocation vec) {
        if (vec == null || !vec.getWorld().equals(this.getWorld())) {
            throw new IllegalArgumentException("Cannot add Locations of differing worlds");
        }
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public AbstractLocation subtract(AbstractVector vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        this.z -= vec.getZ();
        return this;
    }

    public AbstractLocation multiply(double m3) {
        this.x *= m3;
        this.y *= m3;
        this.z *= m3;
        return this;
    }

    public AbstractLocation zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public AbstractVector toVector() {
        return new AbstractVector(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractLocation other = (AbstractLocation)obj;
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        if (Double.doubleToLongBits(this.z) != Double.doubleToLongBits(other.z)) {
            return false;
        }
        if (Float.floatToIntBits(this.pitch) != Float.floatToIntBits(other.pitch)) {
            return false;
        }
        return Float.floatToIntBits(this.yaw) == Float.floatToIntBits(other.yaw);
    }

    public String toString() {
        return "Location{world=" + this.world + ",x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",pitch=" + this.pitch + ",yaw=" + this.yaw + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        hash = 19 * hash + Float.floatToIntBits(this.pitch);
        hash = 19 * hash + Float.floatToIntBits(this.yaw);
        return hash;
    }

    public AbstractLocation clone() {
        try {
            return (AbstractLocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public boolean isLoaded() {
        return this.getWorld().isLocationLoaded(this);
    }

    public AbstractBiome getBiome() {
        return this.getWorld().getLocationBiome(this);
    }
}

