/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.PluginComponent;
import io.lumine.xikage.mythicmobs.adapters.AbstractBossBar;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.ServerInterface;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitBossBar;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyPigZombie;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyPigZombieVillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyZombie;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyZombieVillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitElderGuardian;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPigZombie;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPigZombieVillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitWitherSkeleton;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitZombie;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitZombieVillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.listeners.MobListeners;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobDespawnEvent;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntityType;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class BukkitServer
extends PluginComponent
implements ServerInterface {
    private MobListeners mobListeners;

    public BukkitServer(MythicMobs plugin) {
        super(plugin);
        Events.subscribe(WorldLoadEvent.class, EventPriority.MONITOR).handler(event -> plugin.getVolatileCodeHandler().getWorldHandler().registerWorldAccess(event.getWorld())).bindWith(this);
        Events.subscribe(WorldUnloadEvent.class, EventPriority.MONITOR).handler(event -> plugin.getVolatileCodeHandler().getWorldHandler().unregisterWorldAccess(event.getWorld())).bindWith(this);
    }

    @Override
    public void load(MythicMobs plugin) {
        this.mobListeners = new MobListeners(plugin);
        this.bind(this.mobListeners);
    }

    @Override
    public void unload() {
    }

    @Override
    public List<AbstractWorld> getWorlds() {
        ArrayList<AbstractWorld> wl = new ArrayList<AbstractWorld>();
        for (World w : Bukkit.getWorlds()) {
            wl.add(new BukkitWorld(w));
        }
        return wl;
    }

    @Override
    public void dispatchCommand(String s2) {
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), s2);
    }

    @Override
    public AbstractPlayer getPlayer(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        return BukkitAdapter.adapt(player);
    }

    @Override
    public AbstractPlayer getPlayer(String name) {
        Player player = Bukkit.getPlayerExact((String)name);
        if (player == null) {
            return null;
        }
        return BukkitAdapter.adapt(player);
    }

    @Override
    public AbstractEntity getEntity(UUID uuid) {
        Entity entity = Bukkit.getEntity((UUID)uuid);
        if (entity == null) {
            return null;
        }
        return BukkitAdapter.adapt(entity);
    }

    @Override
    public AbstractWorld getWorld(UUID uuid) {
        World world = Bukkit.getWorld((UUID)uuid);
        if (world == null) {
            return null;
        }
        return BukkitAdapter.adapt(world);
    }

    @Override
    public AbstractWorld getWorld(String name) {
        World world = Bukkit.getWorld((String)name);
        if (world == null) {
            return null;
        }
        return new BukkitWorld(world);
    }

    @Override
    public List<AbstractPlayer> getOnlinePlayers() {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            pl.add(BukkitAdapter.adapt(p));
        }
        return pl;
    }

    @Override
    public AbstractLocation newLocation(AbstractWorld w, double x, double y, double z) {
        Location l = new Location(BukkitAdapter.adapt(w), x, y, z);
        return BukkitAdapter.adapt(l);
    }

    @Override
    public AbstractLocation newLocation(AbstractWorld w, double x, double y, double z, float yaw, float pitch) {
        Location l = new Location(BukkitAdapter.adapt(w), x, y, z, yaw, pitch);
        return BukkitAdapter.adapt(l);
    }

    @Override
    public boolean isValidBiome(Object o) {
        return false;
    }

    @Override
    public AbstractBossBar createBossBar(String title, AbstractBossBar.BarColor color, AbstractBossBar.BarStyle style) {
        return new BukkitBossBar(title, color, style);
    }

    @Override
    public MythicEntityType getMythicEntityType(Entity e) {
        String type;
        switch (type = e.getType().toString()) {
            case "GUARDIAN": {
                if (!BukkitElderGuardian.isInstanceOf(e)) break;
                type = "ELDER_GUARDIAN";
                break;
            }
            case "PIG_ZOMBIE": {
                if (BukkitPigZombie.isInstanceOf(e)) break;
                if (BukkitBabyPigZombie.isInstanceOf(e)) {
                    type = "BABY_PIG_ZOMBIE";
                    break;
                }
                if (BukkitPigZombieVillager.isInstanceOf(e)) {
                    type = "PIG_ZOMBIE_VILLAGER";
                    break;
                }
                if (!BukkitBabyPigZombieVillager.isInstanceOf(e)) break;
                type = "BABY_PIG_ZOMBIE_VILLAGER";
                break;
            }
            case "SKELETON": {
                if (!BukkitWitherSkeleton.isInstanceOf(e)) break;
                type = "WITHER_SKELETON";
                break;
            }
            case "ZOMBIE": {
                if (BukkitZombie.isInstanceOf(e)) break;
                if (BukkitBabyZombie.isInstanceOf(e)) {
                    type = "BABY_ZOMBIE";
                    break;
                }
                if (BukkitZombieVillager.isInstanceOf(e)) {
                    type = "ZOMBIE_VILLAGER";
                    break;
                }
                if (!BukkitBabyZombieVillager.isInstanceOf(e)) break;
                type = "BABY_ZOMBIE_VILLAGER";
            }
        }
        return MythicEntityType.get(type);
    }

    @Override
    public void handleMobDespawnEvent(ActiveMob mob) {
        Schedulers.sync().run(() -> {
            MythicMobDespawnEvent mythicDespawnEvent = new MythicMobDespawnEvent(mob);
            Events.call(mythicDespawnEvent);
        });
    }
}

