/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitBee
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private int anger = 0;
    private boolean hasNectar = false;
    private boolean hasStung = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.anger = mc.getInteger("Options.Anger", 0);
        this.hasNectar = mc.getBoolean("Options.HasNectar", false);
        this.hasStung = mc.getBoolean("Options.HasStung", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.COW, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Bee e = (Bee)entity;
        e.setAnger(this.anger);
        e.setHasNectar(this.hasNectar);
        e.setHasStung(this.hasStung);
        this.ageableProperty.applyProperties(entity);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Bee;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

