/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitCat
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private boolean tameable;
    private String catType;
    private String collarColor;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameable = mc.getBoolean("Options.Tameable", false);
        this.catType = mc.getString("Options.CatType", null);
        this.collarColor = mc.getString("Options.CollarColor", null);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        return this.spawnEntity(location, EntityType.CAT, reason);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Cat e = (Cat)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.catType != null) {
            e.setCatType(Cat.Type.valueOf((String)this.catType.toUpperCase()));
        }
        if (this.collarColor != null) {
            e.setCollarColor(DyeColor.valueOf((String)this.collarColor.toUpperCase()));
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Cat;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }
}

