/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;

public class BukkitFox
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private String foxType;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.foxType = mc.getString("Options.FoxType", null);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.FOX, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Fox e = (Fox)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.foxType != null) {
            e.setFoxType(Fox.Type.valueOf((String)this.foxType));
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Fox;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

