/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mule;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.ItemStack;

public class BukkitMule
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private boolean horseChest;
    private boolean horseSaddled;
    private boolean horseTamed;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.horseChest = mc.getBoolean("Options.HorseCarryingChest", false);
        this.horseChest = mc.getBoolean("Options.CarryingChest", this.horseChest);
        this.horseSaddled = mc.getBoolean("Options.HorseSaddled", false);
        this.horseSaddled = mc.getBoolean("Options.Saddled", this.horseSaddled);
        this.horseTamed = mc.getBoolean("Options.HorseTamed", false);
        this.horseTamed = mc.getBoolean("Options.Tamed", this.horseTamed);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.MULE, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Mule e = (Mule)entity;
        this.ageableProperty.applyProperties(entity);
        AbstractHorseInventory hi = e.getInventory();
        if (this.horseTamed) {
            e.setTamed(true);
        }
        if (this.horseSaddled) {
            hi.setSaddle(new ItemStack(Material.SADDLE, 1, 0));
        }
        if (this.horseChest) {
            e.setCarryingChest(true);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Mule;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

