/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ocelot;

public class BukkitOcelot
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private boolean tameable;
    private String ocelotType;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.ocelotType = mc.getString("Options.Ocelot", null);
        this.ocelotType = mc.getString("Options.OcelotType", this.ocelotType);
        this.tameable = mc.getBoolean("Options.Tameable", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        return this.spawnEntity(location, EntityType.OCELOT, reason);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Ocelot e = (Ocelot)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.ocelotType != null) {
            if (ServerVersion.isBefore(MinecraftVersions.v1_14)) {
                e.setCatType(Ocelot.Type.valueOf((String)this.ocelotType));
            } else {
                MythicLogger.errorGenericConfig("Ocelots no longer have cat types in versions >= 1.14");
            }
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Ocelot;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }
}

