/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Rabbit;

public class BukkitRabbit
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private boolean isAngry = false;
    private boolean isBaby = false;
    private Rabbit.Type type;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.isAngry = mc.getBoolean("Options.IsKillerBunny", false);
        this.isAngry = mc.getBoolean("Options.Angry", this.isAngry);
        this.isBaby = mc.getBoolean("Options.Baby", false);
        String t = mc.getString("Options.RabbitType", null);
        if (t != null) {
            this.type = Rabbit.Type.valueOf((String)t.toUpperCase());
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.RABBIT, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Rabbit e = (Rabbit)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.isBaby) {
            e.setBaby();
        }
        if (this.type != null) {
            e.setRabbitType(this.type);
        }
        if (this.isAngry) {
            e.setRabbitType(Rabbit.Type.THE_KILLER_BUNNY);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Rabbit;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

