/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Slime;

public class BukkitSlime
extends BukkitEntityType {
    private static final int height = 2;
    private int size = -1;
    private boolean preventSplit = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.size = mc.getInt("Options.Size", -1);
        this.preventSplit = mc.getBoolean(".Options.PreventSplit", false);
        this.preventSplit = mc.getBoolean(".Options.PreventSlimeSplit", this.preventSplit);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.SLIME, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Slime e = (Slime)entity;
        if (this.size > 0) {
            e.setSize(this.size);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Slime;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    public boolean canSplit() {
        return !this.preventSplit;
    }
}

