/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.listeners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkListeners
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void ChunkLoadEvent(ChunkLoadEvent e) {
        if (e.getChunk() == null) {
            return;
        }
        ChunkLoader cl = new ChunkLoader(e.getChunk());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.inst(), (Runnable)cl, 10L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void ChunkUnloadedEvent(ChunkUnloadEvent e) {
        String cS = e.getChunk().getWorld().getName() + "-" + e.getChunk().getX() + "-" + e.getChunk().getZ();
        Optional<Collection<MythicSpawner>> maybeSpawners = MythicMobs.inst().getSpawnerManager().getSpawnersByChunk(cS);
        if (maybeSpawners.isPresent()) {
            for (MythicSpawner ms : maybeSpawners.get()) {
                ms.unloadSpawner();
            }
        }
        for (Entity ee : e.getChunk().getEntities()) {
            ActiveMob am;
            if (!(ee instanceof LivingEntity) || (am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)ee))) == null || !am.getType().getDespawns()) continue;
            am.setDespawned();
            MythicMobs.inst().getMobManager().unregisterActiveMob(am);
            ee.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void WorldUnloadEvent(WorldUnloadEvent e) {
        for (Entity ee : e.getWorld().getEntities()) {
            ActiveMob am;
            if (!(ee instanceof LivingEntity) || (am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)ee))) == null) continue;
            if (am.getType().getDespawns()) {
                am.setDespawned();
                MythicMobs.inst().getMobManager().unregisterActiveMob(am);
                ee.remove();
                continue;
            }
            am.setUnloaded();
        }
    }

    private class ChunkLoader
    implements Runnable {
        private Chunk c;

        public ChunkLoader(Chunk c) {
            this.c = c;
        }

        @Override
        public void run() {
            if (!this.c.isLoaded()) {
                return;
            }
            Entity[] el = this.c.getEntities();
            if (el.length == 0) {
                return;
            }
            for (Entity ee : el) {
                ActiveMob am;
                if (!(ee instanceof LivingEntity)) continue;
                LivingEntity l = (LivingEntity)ee;
                if (MythicMobs.inst().getMobManager().isActiveMob(ee.getUniqueId())) {
                    if (l.getRemoveWhenFarAway()) {
                        ee.remove();
                        continue;
                    }
                    am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)ee));
                    if (am == null || am.getType() == null) {
                        ee.remove();
                        continue;
                    }
                    if (am.getType().getDespawns()) {
                        am.setDespawned();
                        MythicMobs.inst().getMobManager().unregisterActiveMob(am);
                        ee.remove();
                        continue;
                    }
                    am.getType().applyMobVolatileOptions(am);
                    continue;
                }
                am = MythicMobs.inst().getMobManager().registerActiveMob(BukkitAdapter.adapt((Entity)l));
                if (am == null) continue;
                new TriggeredSkill(SkillTrigger.SPAWN, am, null, new Pair[0]);
            }
        }
    }
}

