/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.listeners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.PluginComponent;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitMagmaCube;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSilverfish;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSlime;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSnowman;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitWolf;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.WorldScaling;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntityType;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnPoint;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class MobListeners
extends PluginComponent
implements Listener {
    public MobListeners(MythicMobs plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicMobs plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Events.subscribe(SlimeSplitEvent.class, EventPriority.HIGH).handler(event -> {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "SlimeSplitEvent fired", new Object[0]);
            Optional<ActiveMob> maybeMob = this.getPlugin().getMobManager().getActiveMob(event.getEntity().getUniqueId());
            if (maybeMob.isPresent()) {
                BukkitEntityType mythicEntity = maybeMob.get().getType().getMythicEntity();
                if (mythicEntity instanceof BukkitSlime) {
                    if (!((BukkitSlime)mythicEntity).canSplit()) {
                        event.setCount(0);
                        event.setCancelled(true);
                    }
                } else if (mythicEntity instanceof BukkitMagmaCube && !((BukkitMagmaCube)mythicEntity).canSplit()) {
                    event.setCount(0);
                    event.setCancelled(true);
                }
            }
        }).bindWith(this);
        Events.subscribe(CreatureSpawnEvent.class, EventPriority.HIGHEST).handler(event -> {
            MobManager mm3;
            List passengers;
            if (ConfigManager.debugMode) {
                return;
            }
            if (ConfigManager.debugSpawners) {
                return;
            }
            if (this.getPlugin().getCompatibility().getWorldGuard().isPresent() && !this.getPlugin().getCompatibility().getWorldGuard().get().LocationAllowsMobSpawning(event.getLocation())) {
                return;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "CreatureSpawnEvent fired", new Object[0]);
            AbstractEntity spawn = BukkitAdapter.adapt((Entity)event.getEntity());
            if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL || event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CHUNK_GEN) {
                if (ConfigManager.isVanillaSpawnsDisabled() && !BukkitEntityType.getIsSpawning().booleanValue()) {
                    event.setCancelled(true);
                }
                int mobsInChunk = 0;
                try {
                    AbstractWorld world = spawn.getLocation().getWorld();
                    int x = spawn.getLocation().getBlockX() >> 4;
                    int z = spawn.getLocation().getBlockZ() >> 4;
                    mobsInChunk = world.getEntitiesInChunk(x, z);
                    MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "| Mobs in chunk calculated to be {0}", mobsInChunk);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (mobsInChunk >= ConfigManager.getRSMaxMobsPerChunk()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "! Too many entities in chunk, cancelling", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            } else if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.JOCKEY && !(passengers = event.getEntity().getPassengers()).isEmpty() && (mm3 = this.getPlugin().getMobManager()).isActiveMob(((Entity)passengers.get(0)).getUniqueId()) && !mm3.isActiveMob(event.getEntity().getUniqueId()) && mm3.getMythicMobInstance((Entity)passengers.get(0)).getType().getPreventJockeyMounts().booleanValue()) {
                event.setCancelled(true);
                return;
            }
            RandomSpawnPoint rsp = new RandomSpawnPoint(BukkitAdapter.adapt((Entity)event.getEntity()), BukkitAdapter.adapt(event.getLocation()), event.getSpawnReason());
            Entity ee = BukkitAdapter.adapt(this.getPlugin().getRandomSpawningManager().handleSpawnEvent(rsp));
            if (ee != null) {
                event.setCancelled(true);
            } else if (event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.BREEDING && !BukkitEntityType.getIsSpawning().booleanValue()) {
                MythicEntityType met = this.getPlugin().server().getMythicEntityType((Entity)event.getEntity());
                Optional<MythicMob> maybeType = this.getPlugin().getMobManager().getVanillaType(met);
                if (maybeType.isPresent()) {
                    MythicMob mm4 = maybeType.get();
                    int level = 1 + WorldScaling.getLevelBonus(spawn.getLocation());
                    ActiveMob am = this.getPlugin().getMobManager().registerActiveMob(spawn, mm4, level);
                    mm4.getMythicEntity().applyOptions((Entity)event.getEntity());
                    mm4.applyMobOptions(am, level);
                    mm4.applyMobVolatileOptions(am);
                    mm4.applySpawnModifiers(am);
                }
            }
            if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
                if (ConfigManager.UseCompatibilityMode) {
                    LivingEntity l = event.getEntity();
                    Schedulers.sync().runLater(() -> {
                        if (!this.getPlugin().getMobManager().isActiveMob(spawn.getUniqueId())) {
                            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Compatibility mode enabled and found custom mob spawn! Checking for MythicMob '" + l.getCustomName() + "'...", new Object[0]);
                            MythicMob mm3 = this.getPlugin().getMobManager().getMythicMobByDisplayCompat(spawn);
                            if (mm3 != null) {
                                this.getPlugin().getMobManager().SetupMythicMobCompat(l, mm3);
                            } else {
                                this.getPlugin().getMobManager().setIgnoreEntity(l.getUniqueId());
                            }
                        }
                    }, 10L);
                } else {
                    LivingEntity l = event.getEntity();
                    Schedulers.sync().runLater(() -> {
                        if (!this.getPlugin().getMobManager().isActiveMob(l.getUniqueId())) {
                            this.getPlugin().getMobManager().setIgnoreEntity(l.getUniqueId());
                        }
                    }, 20L);
                }
            }
        }).bindWith(this);
        Events.subscribe(ChunkLoadEvent.class, EventPriority.HIGHEST).filter(event -> event.isNewChunk()).handler(event -> {
            if (ConfigManager.debugMode) {
                return;
            }
            if (ConfigManager.debugSpawners) {
                return;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "ChunkLoadEvent (New Chunk) fired", new Object[0]);
            for (Entity entity : event.getChunk().getEntities()) {
                if (this.getPlugin().getCompatibility().getWorldGuard().isPresent() && !this.getPlugin().getCompatibility().getWorldGuard().get().LocationAllowsMobSpawning(entity.getLocation())) {
                    entity.remove();
                    continue;
                }
                AbstractEntity spawn = BukkitAdapter.adapt(entity);
                RandomSpawnPoint rsp = new RandomSpawnPoint(spawn, spawn.getLocation(), CreatureSpawnEvent.SpawnReason.NATURAL);
                Entity ee = BukkitAdapter.adapt(this.getPlugin().getRandomSpawningManager().handleSpawnEvent(rsp));
                if (ee != null) {
                    entity.remove();
                    continue;
                }
                if (!ConfigManager.isVanillaSpawnsDisabled() || BukkitEntityType.getIsSpawning().booleanValue()) continue;
                entity.remove();
            }
        }).bindWith(this);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
            Events.subscribe(EntityTransformEvent.class).handler(event -> {
                ActiveMob am;
                if (this.getPlugin().getMobManager().isActiveMob(event.getEntity().getUniqueId()) && (am = this.getPlugin().getMobManager().getMythicMobInstance(event.getEntity())).getType().getPreventTransformation().booleanValue()) {
                    event.setCancelled(true);
                }
            }).bindWith(this);
        }
    }

    @Override
    public void unload() {
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void damagePassthroughEvent(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Damageable)) {
            return;
        }
        Damageable damaged = (Damageable)event.getEntity();
        if (!this.getPlugin().getMobManager().isActiveMob(damaged.getUniqueId())) {
            return;
        }
        ActiveMob am = this.getPlugin().getMobManager().getMythicMobInstance((Entity)damaged);
        if (!am.getType().getPassthroughDamage().booleanValue() || am.getParent() == null) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.TRIGGER, "Passing damage to parent", new Object[0]);
        event.setCancelled(true);
        LivingEntity parent = (LivingEntity)am.getParent().getEntity().getBukkitEntity();
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent ee = (EntityDamageByEntityEvent)event;
            Entity damager = ee.getDamager();
            if (damager instanceof Projectile) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Damage passed from arrow", new Object[0]);
                ProjectileSource shooter = ((Projectile)damager).getShooter();
                if (shooter instanceof LivingEntity) {
                    parent.damage(ee.getDamage(), (Entity)((Projectile)damager).getShooter());
                } else {
                    parent.damage(event.getDamage());
                }
                damager.remove();
            } else {
                parent.damage(ee.getDamage(), damager);
            }
        } else {
            parent.damage(event.getDamage());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMobTame(EntityTameEvent event) {
        LivingEntity e = event.getEntity();
        if (this.getPlugin().getMobManager().isActiveMob(e.getUniqueId())) {
            ActiveMob am = this.getPlugin().getMobManager().getMythicMobInstance((Entity)e);
            Schedulers.sync().runLater(() -> {
                am.getType().applyMobOptions(am, am.getLevel());
                am.getType().applyMobVolatileOptions(am);
            }, 5L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void TagEntity(PlayerInteractEntityEvent e) {
        if (!(e.getRightClicked() instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)e.getRightClicked();
        if (!this.getPlugin().getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        EntityEquipment ee = e.getPlayer().getEquipment();
        if (ee != null && ee.getItemInMainHand().getType() != Material.NAME_TAG) {
            return;
        }
        if (this.getPlugin().getMobManager().getMythicMobInstance((Entity)l).getType().getPreventRename().booleanValue()) {
            e.setCancelled(true);
            e.getPlayer().sendActionBar("\u00a7cThis mob can't be renamed");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCombust(EntityCombustEvent event) {
        ActiveMob am;
        if (event instanceof EntityCombustByEntityEvent || event instanceof EntityCombustByBlockEvent) {
            return;
        }
        World world = event.getEntity().getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return;
        }
        Entity entity = event.getEntity();
        if (this.getPlugin().getMobManager().isActiveMob(entity.getUniqueId()) && (am = this.getPlugin().getMobManager().getMythicMobInstance(entity)).getType().getPreventSunburn().booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTameEntity(PlayerInteractEntityEvent e) {
        if (!(e.getRightClicked() instanceof LivingEntity)) {
            return;
        }
        if (e.getPlayer().getItemInHand().getType() != Material.BONE) {
            return;
        }
        LivingEntity l = (LivingEntity)e.getRightClicked();
        if (!this.getPlugin().getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = this.getPlugin().getMobManager().getMythicMobInstance((Entity)l);
        if (am.getType().getMythicEntity() instanceof BukkitWolf && !((BukkitWolf)am.getType().getMythicEntity()).isTameable()) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(ChatColor.RED + "That mob can't be tamed!");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLeashEntity(PlayerLeashEntityEvent e) {
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)e.getEntity();
        if (!this.getPlugin().getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = this.getPlugin().getMobManager().getMythicMobInstance((Entity)l);
        if (am.getType().getPreventLeashing().booleanValue()) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(ChatColor.RED + "That mob can't be leashed!");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockForm(EntityBlockFormEvent e) {
        ActiveMob am;
        if (this.getPlugin().getMobManager().isActiveMob(e.getEntity().getUniqueId()) && (am = this.getPlugin().getMobManager().getMythicMobInstance(e.getEntity())).getType().getMythicEntity() instanceof BukkitSnowman && ((BukkitSnowman)am.getType().getMythicEntity()).getPreventSnowFormation()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTeleportEvent(EntityTeleportEvent e) {
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        ActiveMob am = this.getPlugin().getMobManager().getMythicMobInstance(e.getEntity());
        if (am == null) {
            return;
        }
        if (am.getType().getPreventEndermanTeleport().booleanValue()) {
            e.getEntity().teleport(e.getFrom());
            e.setCancelled(true);
        } else {
            TriggeredSkill ts = new TriggeredSkill(SkillTrigger.TELEPORT, am, null, new Pair[0]);
            if (ts.getCancelled()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChangeBlockEvent(EntityChangeBlockEvent e) {
        ActiveMob am;
        if (this.getPlugin().getMobManager().isActiveMob(e.getEntity().getUniqueId()) && (am = this.getPlugin().getMobManager().getMythicMobInstance(e.getEntity())).getType().getMythicEntity() instanceof BukkitSilverfish && ((BukkitSilverfish)am.getType().getMythicEntity()).getPreventBlockInfection()) {
            e.setCancelled(true);
            LivingEntity l = (LivingEntity)e.getEntity();
            ActiveMob amN = am.getType().spawn(am.getEntity().getLocation(), am.getLevel(), SpawnReason.OTHER);
            LivingEntity ll = (LivingEntity)BukkitAdapter.adapt(amN.getEntity());
            ll.setMaxHealth(l.getMaxHealth());
            ll.setHealth(l.getHealth());
            if (l.getPassenger() != null) {
                ll.setPassenger(l.getPassenger());
            }
            if (l.getVehicle() != null) {
                l.getVehicle().setPassenger((Entity)ll);
            }
            Collection pe = l.getActivePotionEffects();
            for (PotionEffect p : pe) {
                ll.addPotionEffect(p);
            }
            ActiveMob am2 = this.getPlugin().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)ll));
            if (am2 == null) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Something prevented Silverfish from respawning! PreventBlockInfection failed :(", new Object[0]);
                return;
            }
            am2.setStance(am.getStance());
            am2.importPlayerKills(am.getPlayerKills());
            am2.importThreatTable(am.getThreatTable());
            l.remove();
            am.setDead();
        }
    }
}

