/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.listeners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class ThreatTableListeners
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void MobTargetEventNoOwner(EntityTargetLivingEntityEvent e) {
        if (e.getTarget() == null) {
            return;
        }
        if (!MythicMobs.inst().getMobManager().isActiveMob(e.getEntity().getUniqueId())) {
            return;
        }
        ActiveMob amE = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)e.getEntity()));
        if (amE.getOwner().isPresent() && amE.getOwner().get().equals(e.getTarget().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void MobTargetEventNoFaction(EntityTargetLivingEntityEvent e) {
        if (e.getTarget() == null) {
            return;
        }
        if (!MythicMobs.inst().getMobManager().isActiveMob(e.getEntity().getUniqueId())) {
            return;
        }
        if (!MythicMobs.inst().getMobManager().isActiveMob(e.getTarget().getUniqueId())) {
            return;
        }
        ActiveMob amE = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)e.getEntity()));
        ActiveMob amT = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)e.getTarget());
        if (amE.getFaction() != null && amE.getFaction().equals(amT.getFaction())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void MobTargetEvent(EntityTargetLivingEntityEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!ConfigManager.EnableThreatTables) {
            return;
        }
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)e.getEntity()));
        if (am == null) {
            return;
        }
        if (am.isDead() || !am.getType().usesThreatTable()) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Target Change Event called, reviewing Threat Table", new Object[0]);
        if (!am.getThreatTable().targetEvent(BukkitAdapter.adapt((Entity)e.getTarget()))) {
            e.setCancelled(true);
            am.setTarget(am.getThreatTable().getTopThreatHolder());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void MobTargetEvent(EntityTargetEvent e) {
        if (!ConfigManager.EnableThreatTables) {
            return;
        }
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)e.getEntity()));
        if (am == null || am.getType() == null) {
            return;
        }
        if (am.isDead() || !am.getType().usesThreatTable() || am.getThreatTable().inCombat()) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Target Change Event called, reviewing Threat Table", new Object[0]);
        if (!am.getThreatTable().targetEvent(BukkitAdapter.adapt(e.getTarget()))) {
            e.setCancelled(true);
            am.setTarget(am.getThreatTable().getTopThreatHolder());
        }
    }
}

