/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.clock;

import java.util.HashMap;

public class TimingsHandler {
    private boolean enabled = false;
    private long startTime;
    private long total;
    private long lastMark;
    private long scannerTotal;
    private long scannerLastMark;
    private long skillsTotal;
    private long skillsLastMark;
    private long spawnersTotal;
    private long spawnersLastMark;
    private long randomSpawnersTotal;
    private long randomSpawnersLastMark;
    private long randomGeneratorsTotal;
    private long randomGeneratorsLastMark;
    private long threattablesTotal;
    private long threattablesLastMark;
    private HashMap<String, Long> skillMarks = new HashMap();
    private HashMap<String, Long> skillTimings = new HashMap();
    private HashMap<String, Long> spawnerMarks = new HashMap();
    private HashMap<String, Long> spawnerTimings = new HashMap();

    public void enable() {
        this.startTime = System.nanoTime();
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void reset() {
        this.startTime = System.nanoTime();
        this.total = 0L;
        this.lastMark = 0L;
        this.scannerTotal = 0L;
        this.scannerLastMark = 0L;
        this.skillsTotal = 0L;
        this.skillsLastMark = 0L;
        this.spawnersTotal = 0L;
        this.spawnersLastMark = 0L;
        this.randomSpawnersTotal = 0L;
        this.randomSpawnersLastMark = 0L;
        this.randomGeneratorsTotal = 0L;
        this.randomGeneratorsLastMark = 0L;
        this.threattablesTotal = 0L;
        this.threattablesLastMark = 0L;
        this.spawnerMarks.clear();
        this.spawnerTimings.clear();
        this.skillMarks.clear();
        this.skillTimings.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void markTotalNew() {
        if (!this.enabled) {
            return;
        }
        this.lastMark = System.nanoTime();
    }

    public void markTotalComplete() {
        if (!this.enabled) {
            return;
        }
        if (this.lastMark == 0L) {
            return;
        }
        this.total += System.nanoTime() - this.lastMark;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getRunTime() {
        return System.nanoTime() - this.startTime;
    }

    public double getRunTimeMillis() {
        return Math.round((System.nanoTime() - this.startTime) / 10000L) / 100;
    }

    public long getTimeTotal() {
        return this.total;
    }

    public void markScannerNew() {
        if (!this.enabled) {
            return;
        }
        this.scannerLastMark = System.nanoTime();
    }

    public void markScannerComplete() {
        if (!this.enabled) {
            return;
        }
        if (this.scannerLastMark == 0L) {
            return;
        }
        this.scannerTotal += System.nanoTime() - this.scannerLastMark;
    }

    public long getTimeScanner() {
        return this.scannerTotal;
    }

    public void markSkillsNew() {
        if (!this.enabled) {
            return;
        }
        this.skillsLastMark = System.nanoTime();
    }

    public void markSkillsComplete() {
        if (!this.enabled) {
            return;
        }
        if (this.skillsLastMark == 0L) {
            return;
        }
        this.skillsTotal += System.nanoTime() - this.skillsLastMark;
    }

    public long getTimeSkills() {
        return this.skillsTotal;
    }

    public void markRandomSpawnersNew() {
        if (!this.enabled) {
            return;
        }
        this.randomSpawnersLastMark = System.nanoTime();
    }

    public void markRandomSpawnersComplete() {
        if (!this.enabled) {
            return;
        }
        if (this.randomSpawnersLastMark == 0L) {
            return;
        }
        this.randomSpawnersTotal += System.nanoTime() - this.randomSpawnersLastMark;
    }

    public long getTimeRandomSpawners() {
        return this.randomSpawnersTotal;
    }

    public void markRandomGeneratorsNew() {
        if (!this.enabled) {
            return;
        }
        this.randomGeneratorsLastMark = System.nanoTime();
    }

    public void markRandomGeneratorsComplete() {
        if (!this.enabled) {
            return;
        }
        if (this.randomGeneratorsLastMark == 0L) {
            return;
        }
        this.randomGeneratorsTotal += System.nanoTime() - this.randomGeneratorsLastMark;
    }

    public long getTimeRandomGenerators() {
        return this.randomGeneratorsTotal;
    }

    public void markSpawnersNew() {
        if (!this.enabled) {
            return;
        }
        this.spawnersLastMark = System.nanoTime();
    }

    public void markSpawnersComplete() {
        if (!this.enabled) {
            return;
        }
        if (this.spawnersLastMark == 0L) {
            return;
        }
        this.spawnersTotal += System.nanoTime() - this.spawnersLastMark;
    }

    public long getTimeSpawners() {
        return this.spawnersTotal;
    }

    public void markThreatTablesNew() {
        if (!this.enabled) {
            return;
        }
        this.threattablesLastMark = System.nanoTime();
    }

    public void markThreatTablesComplete() {
        if (!this.enabled) {
            return;
        }
        if (this.threattablesLastMark == 0L) {
            return;
        }
        this.threattablesTotal += System.nanoTime() - this.threattablesLastMark;
    }

    public long getTimeThreatTables() {
        return this.threattablesTotal;
    }

    public void markSpawnerNew(String s2) {
        if (!this.enabled) {
            return;
        }
        this.spawnerMarks.put(s2, System.nanoTime());
    }

    public void markSpawnerComplete(String s2) {
        if (!this.enabled) {
            return;
        }
        long l = 0L;
        if (!this.spawnerMarks.containsKey(s2)) {
            return;
        }
        l = this.spawnerMarks.get(s2);
        if (this.spawnerTimings.containsKey(s2)) {
            long ct = this.spawnerTimings.get(s2);
            this.spawnerTimings.put(s2, ct + (System.nanoTime() - l));
        } else {
            this.spawnerTimings.put(s2, System.nanoTime() - l);
        }
    }

    public HashMap<String, Long> getAllSpawnerTimes() {
        return this.spawnerTimings;
    }

    public void markSkillNew(String s2) {
        if (!this.enabled) {
            return;
        }
        this.skillMarks.put(s2, System.nanoTime());
    }

    public void markSkillComplete(String s2) {
        if (!this.enabled) {
            return;
        }
        long l = 0L;
        if (!this.skillMarks.containsKey(s2)) {
            return;
        }
        l = this.skillMarks.get(s2);
        if (this.skillTimings.containsKey(s2)) {
            long ct = this.skillTimings.get(s2);
            this.skillTimings.put(s2, ct + (System.nanoTime() - l));
        } else {
            this.skillTimings.put(s2, System.nanoTime() - l);
        }
    }

    public HashMap<String, Long> getAllSkillTimes() {
        return this.skillTimings;
    }
}

