/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.debug;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class TimingsCommand
extends Command<MythicMobs> {
    public TimingsCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length > 0) {
            if ("ON".equals(args[0].toUpperCase())) {
                MythicMobs.inst().getTimingsHandler().enable();
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Timings have been enabled.");
                return true;
            } else if ("OFF".equals(args[0].toUpperCase())) {
                MythicMobs.inst().getTimingsHandler().disable();
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Timings have been disabled.");
                return true;
            } else if ("RESET".equals(args[0].toUpperCase())) {
                MythicMobs.inst().getTimingsHandler().reset();
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Timings have been reset.");
                return true;
            } else if ("SPAWNERS".equals(args[0].toUpperCase())) {
                double overallMS = MythicMobs.inst().getTimingsHandler().getRunTimeMillis();
                double totalMS = MythicMobs.inst().getTimingsHandler().getTimeTotal() / 1000000L;
                double totalSpawners = MythicMobs.inst().getTimingsHandler().getTimeSpawners() / 1000000L;
                MythicLogger.log("Spawner Timings");
                MythicLogger.log("Time Analyzed: " + overallMS);
                MythicLogger.log("Clock Time: " + Math.round(totalMS * 100.0) / 100L + "ms (" + Math.round(totalMS / overallMS * 10000.0) / 100L + "%)");
                MythicLogger.log("- CSpawners: " + Math.round(totalSpawners * 100.0) / 100L + "ms (" + Math.round(totalSpawners / totalMS * 10000.0) / 100L + "% Clock, " + Math.round(totalSpawners / overallMS * 10000.0) / 100L + "% Overall)");
                MythicLogger.log("-- All Spawners:");
                HashMap map = (HashMap)MythicMobs.inst().getTimingsHandler().getAllSpawnerTimes().clone();
                map = TimingsCommand.sortHashMapByValuesD(map);
                for (String s2 : map.keySet()) {
                    long tM = (Long)map.get(s2) / 1000000L;
                    long tMTS = Math.round((double)tM / totalSpawners * 10000.0) / 100L;
                    long tMC = Math.round((double)tM / totalMS * 10000.0) / 100L;
                    long tMO = Math.round((double)tM / overallMS * 10000.0) / 100L;
                    MythicLogger.log(String.format("** %32s %8d ms - %4d pS %4d pC %4d pOverall)", s2, tM, tMTS, tMC, tMO));
                }
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Spawner timings have been pasted to the console.");
                return true;
            } else {
                if (!"SKILLS".equals(args[0].toUpperCase())) return false;
                double overallMS = MythicMobs.inst().getTimingsHandler().getRunTimeMillis();
                double totalMS = MythicMobs.inst().getTimingsHandler().getTimeTotal() / 1000000L;
                double totalSkills = MythicMobs.inst().getTimingsHandler().getTimeSkills() / 1000000L;
                MythicLogger.log(" AbstractSkill Timings");
                MythicLogger.log("Time Analyzed: " + overallMS);
                MythicLogger.log("Clock Time: " + Math.round(totalMS * 100.0) / 100L + "ms (" + Math.round(totalMS / overallMS * 10000.0) / 100L + "%)");
                MythicLogger.log("- TmrSkills: " + Math.round(totalSkills * 100.0) / 100L + "ms (" + Math.round(totalSkills / totalMS * 10000.0) / 100L + "% Clock, " + Math.round(totalSkills / overallMS * 10000.0) / 100L + "% Overall)");
                MythicLogger.log("-- All Timer Skills:");
                HashMap map = (HashMap)MythicMobs.inst().getTimingsHandler().getAllSkillTimes().clone();
                map = TimingsCommand.sortHashMapByValuesD(map);
                for (String s3 : map.keySet()) {
                    long tM = (Long)map.get(s3) / 1000000L;
                    long tMTS = Math.round((double)tM / totalSkills * 10000.0) / 100L;
                    long tMC = Math.round((double)tM / totalMS * 10000.0) / 100L;
                    long tMO = Math.round((double)tM / overallMS * 10000.0) / 100L;
                    MythicLogger.log(String.format("** %64s %8d ms - %4d pS %4d pC %4d pOverall)", s3, tM, tMTS, tMC, tMO));
                }
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " AbstractSkill timings have been pasted to the console.");
            }
            return true;
        } else {
            if (!MythicMobs.inst().getTimingsHandler().isEnabled()) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Timings must be enabled first.");
                return true;
            }
            double overallMS = MythicMobs.inst().getTimingsHandler().getRunTimeMillis();
            double totalMS = MythicMobs.inst().getTimingsHandler().getTimeTotal() / 1000000L;
            double totalSkills = MythicMobs.inst().getTimingsHandler().getTimeSkills() / 1000000L;
            double totalRandomSpawners = MythicMobs.inst().getTimingsHandler().getTimeRandomSpawners() / 1000000L;
            double totalRandomGenerators = MythicMobs.inst().getTimingsHandler().getTimeRandomGenerators() / 1000000L;
            double totalScanner = MythicMobs.inst().getTimingsHandler().getTimeScanner() / 1000000L;
            double totalSpawners = MythicMobs.inst().getTimingsHandler().getTimeSpawners() / 1000000L;
            double totalThreatT = MythicMobs.inst().getTimingsHandler().getTimeThreatTables() / 1000000L;
            double overhead = totalMS - totalSkills - totalSpawners - totalThreatT - totalScanner - totalRandomSpawners;
            sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + " Clock Timings");
            sender.sendMessage(ChatColor.AQUA + "Time Analyzed: " + overallMS);
            sender.sendMessage(ChatColor.AQUA + "Clock Time: " + ChatColor.GREEN + (double)Math.round(totalMS * 100.0) / 100.0 + "ms (" + (double)Math.round(totalMS / overallMS * 10000.0) / 100.0 + "%)");
            sender.sendMessage(ChatColor.AQUA + "- Skills & Conditions: " + ChatColor.GREEN + (double)Math.round(totalSkills * 100.0) / 100.0 + "ms (" + (double)Math.round(totalSkills / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalSkills / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- RndSpawns(Replaced): " + ChatColor.GREEN + (double)Math.round(totalRandomSpawners * 100.0) / 100.0 + "ms (" + (double)Math.round(totalRandomSpawners / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalRandomSpawners / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- RndSpawns(Generate): " + ChatColor.GREEN + (double)Math.round(totalRandomGenerators * 100.0) / 100.0 + "ms (" + (double)Math.round(totalRandomGenerators / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalRandomGenerators / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- Static Mob Spawners: " + ChatColor.GREEN + (double)Math.round(totalSpawners * 100.0) / 100.0 + "ms (" + (double)Math.round(totalSpawners / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalSpawners / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- World Scanner: " + ChatColor.GREEN + (double)Math.round(totalScanner * 100.0) / 100.0 + "ms (" + (double)Math.round(totalScanner / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalScanner / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- Threat Tables: " + ChatColor.GREEN + (double)Math.round(totalThreatT * 100.0) / 100.0 + "ms (" + (double)Math.round(totalThreatT / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalThreatT / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(ChatColor.AQUA + "- Overhead+: " + ChatColor.GREEN + (double)Math.round(overhead * 100.0) / 100.0 + "ms (" + (double)Math.round(overhead / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(overhead / overallMS * 10000.0) / 100.0 + "% Overall)");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.debug.timings";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "timings";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"t"};
    }

    private static LinkedHashMap sortHashMapByValuesD(HashMap passedMap) {
        ArrayList mapKeys = new ArrayList(passedMap.keySet());
        ArrayList mapValues = new ArrayList(passedMap.values());
        Collections.sort(mapValues);
        Collections.sort(mapKeys);
        LinkedHashMap<String, Long> sortedMap = new LinkedHashMap<String, Long>();
        block0: for (Object val : mapValues) {
            for (Object key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put((String)key, (Long)val);
                continue block0;
            }
        }
        return sortedMap;
    }
}

