/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Holograms.HologramManager;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.holograms.HologramProvider;
import io.lumine.xikage.mythicmobs.holograms.IHologram;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.event.Listener;

public class CMISupport
implements HologramProvider,
Listener {
    private final MythicMobs core;
    private final CMI cmi;
    private HologramManager hologramManager;

    public CMISupport(MythicMobs mm3) {
        this.core = mm3;
        this.cmi = CMI.getInstance();
        this.hologramManager = this.cmi.getHologramManager();
    }

    @Override
    public void cleanup() {
        this.hologramManager.getHolograms().values().forEach(hologram -> {
            if (hologram.getName().startsWith("#Temp")) {
                Schedulers.sync().runLater(() -> {
                    hologram.hide();
                    this.hologramManager.removeHolo(hologram);
                }, 1L);
            }
        });
    }

    @Override
    public IHologram createHologram(String name, AbstractLocation location, String text) {
        return new CMIHologramImpl(name, location, text);
    }

    public class CMIHologramImpl
    implements IHologram {
        private CMIHologram hologram;

        public CMIHologramImpl(String name, AbstractLocation location, String text) {
            this.hologram = new CMIHologram(name, BukkitAdapter.adapt(location));
            this.hologram.setLines(Arrays.asList(text));
            this.hologram.setSaveToFile(false);
            this.hologram.setInteractable(false);
            this.hologram.setUpdateIntervalSec(0.05);
            CMISupport.this.hologramManager.addHologram(this.hologram);
            this.hologram.enable();
            this.hologram.update();
        }

        @Override
        public void close() {
            MythicLogger.log("Terminated hologram");
            this.hologram.disable();
            this.hologram.refresh();
            Schedulers.sync().run(() -> CMISupport.this.hologramManager.removeHolo(this.hologram));
        }

        @Override
        public void teleport(AbstractLocation location) {
            MythicLogger.log("Teleported hologram");
            this.hologram.setLoc(BukkitAdapter.adapt(location));
            this.hologram.refresh();
        }

        @Override
        public void setText(String text) {
            this.hologram.setLines(Arrays.asList(text));
            this.hologram.refresh();
        }

        @Override
        public void setText(String[] text, String linePrefix) {
            ArrayList<String> list = new ArrayList<String>();
            for (String string : text) {
                list.add(linePrefix + string);
            }
            this.hologram.setLines(list);
            this.hologram.refresh();
        }
    }
}

