/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.compatibility.ArtifactsSupport;
import io.lumine.xikage.mythicmobs.compatibility.EffectLibSupport;
import io.lumine.xikage.mythicmobs.compatibility.EnchantsPlusSupport;
import io.lumine.xikage.mythicmobs.compatibility.HeroesSupport;
import io.lumine.xikage.mythicmobs.compatibility.HologramsSupport;
import io.lumine.xikage.mythicmobs.compatibility.HolographicDisplaysSupport;
import io.lumine.xikage.mythicmobs.compatibility.LibsDisguisesSupport;
import io.lumine.xikage.mythicmobs.compatibility.MMOItemsSupport;
import io.lumine.xikage.mythicmobs.compatibility.MPetCompat;
import io.lumine.xikage.mythicmobs.compatibility.MythicDropsSupport;
import io.lumine.xikage.mythicmobs.compatibility.MythicEnchantsSupport;
import io.lumine.xikage.mythicmobs.compatibility.NoCheatPlusSupport;
import io.lumine.xikage.mythicmobs.compatibility.OpenTerrainGeneratorSupport;
import io.lumine.xikage.mythicmobs.compatibility.PhatLootsSupport;
import io.lumine.xikage.mythicmobs.compatibility.PlaceholderAPISupport;
import io.lumine.xikage.mythicmobs.compatibility.ProtocolLibSupport;
import io.lumine.xikage.mythicmobs.compatibility.RelicsSupport;
import io.lumine.xikage.mythicmobs.compatibility.SkillAPISupport;
import io.lumine.xikage.mythicmobs.compatibility.VaultSupport;
import io.lumine.xikage.mythicmobs.compatibility.WorldGuardSupport;
import io.lumine.xikage.mythicmobs.compatibility.mcMMOSupport;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import java.util.Optional;
import org.bukkit.Bukkit;

public class CompatibilityManager
implements Terminable {
    private Optional<ArtifactsSupport> artifacts = Optional.empty();
    private Optional<MythicEnchantsSupport> mythicEnchants = Optional.empty();
    private Optional<HologramsSupport> holograms = Optional.empty();
    private Optional<HolographicDisplaysSupport> holographicDisplays = Optional.empty();
    private Optional<MMOItemsSupport> MMOItems = Optional.empty();
    private Optional<MPetCompat> miniaturePets = Optional.empty();
    private Optional<NoCheatPlusSupport> noCheatPlus = Optional.empty();
    private Optional<OpenTerrainGeneratorSupport> openTerrainGenerator = Optional.empty();
    private Optional<PlaceholderAPISupport> placeholderAPI = Optional.empty();
    private Optional<ProtocolLibSupport> protocolLib = Optional.empty();
    private Optional<RelicsSupport> relics = Optional.empty();
    private Optional<VaultSupport> vault = Optional.empty();
    private Optional<WorldGuardSupport> worldGuard = Optional.empty();
    public static EffectLibSupport EffectLib = null;
    public static EnchantsPlusSupport EnchantsPlus = null;
    public static HeroesSupport Heroes = null;
    public static LibsDisguisesSupport LibsDisguises = null;
    public static mcMMOSupport mcMMO = null;
    public static MythicDropsSupport MythicDrops = null;
    public static PhatLootsSupport PhatLoots = null;
    public static SkillAPISupport SkillAPI = null;

    public CompatibilityManager(MythicMobs core) {
        this.registerCompatibility("MythicArtifacts", () -> {
            this.artifacts = Optional.of(new ArtifactsSupport());
        });
        this.registerCompatibility("MythicEnchants", () -> {
            this.mythicEnchants = Optional.of(new MythicEnchantsSupport());
        });
        this.registerCompatibility("EnchantsPlus", () -> {
            EnchantsPlus = new EnchantsPlusSupport();
        });
        this.registerCompatibility("Heroes", () -> {
            Heroes = new HeroesSupport();
        });
        this.registerCompatibility("Holograms", () -> {
            this.holograms = Optional.of(new HologramsSupport(core));
        });
        this.registerCompatibility("HolographicDisplays", () -> {
            this.holographicDisplays = Optional.of(new HolographicDisplaysSupport(core));
        });
        this.registerCompatibility("LibsDisguises", () -> {
            LibsDisguises = new LibsDisguisesSupport();
        });
        this.registerCompatibility("mcMMO", () -> {
            mcMMO = new mcMMOSupport();
        });
        this.registerCompatibility("MiniaturePets", () -> {
            this.miniaturePets = Optional.of(new MPetCompat());
        });
        this.registerCompatibility("MMOItems", () -> {
            this.MMOItems = Optional.of(new MMOItemsSupport(core));
        });
        this.registerCompatibility("MythicDrops", () -> {
            MythicDrops = new MythicDropsSupport();
        });
        this.registerCompatibility("NoCheatPlus", () -> {
            this.noCheatPlus = Optional.of(new NoCheatPlusSupport());
        });
        this.registerCompatibility("OpenTerrainGenerator", () -> {
            this.openTerrainGenerator = Optional.of(new OpenTerrainGeneratorSupport());
        });
        this.registerCompatibility("PhatLoots", () -> {
            PhatLoots = new PhatLootsSupport();
        });
        this.registerCompatibility("PlaceholderAPI", () -> {
            this.placeholderAPI = Optional.of(new PlaceholderAPISupport(core));
        });
        this.registerCompatibility("ProtocolLib", () -> {
            this.protocolLib = Optional.of(new ProtocolLibSupport(core));
        });
        this.registerCompatibility("Relics", () -> {
            this.relics = Optional.of(new RelicsSupport());
        });
        this.registerCompatibility("SkillAPI", () -> {
            SkillAPI = new SkillAPISupport();
        });
        this.registerCompatibility("Vault", () -> {
            this.vault = Optional.of(new VaultSupport());
        });
        this.registerCompatibility("WorldGuard", () -> {
            this.worldGuard = Optional.of(new WorldGuardSupport());
        });
    }

    @Override
    public void close() {
    }

    private void registerCompatibility(String name, Runnable run) {
        try {
            if (Bukkit.getPluginManager().getPlugin(name) != null) {
                run.run();
                MythicLogger.log("MythicMobs " + name + " Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicLogger.errorCompatibility(name, "Plugin not found/incompatible version");
            if (ConfigManager.debugLevel > 0) {
                er.printStackTrace();
            }
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to enable support for " + name + ". Is it up to date?");
            ex.printStackTrace();
        }
    }

    public Optional<ArtifactsSupport> getArtifacts() {
        return this.artifacts;
    }

    public Optional<MythicEnchantsSupport> getMythicEnchants() {
        return this.mythicEnchants;
    }

    public Optional<HologramsSupport> getHolograms() {
        return this.holograms;
    }

    public Optional<HolographicDisplaysSupport> getHolographicDisplays() {
        return this.holographicDisplays;
    }

    public Optional<MMOItemsSupport> getMMOItems() {
        return this.MMOItems;
    }

    public Optional<MPetCompat> getMiniaturePets() {
        return this.miniaturePets;
    }

    public Optional<NoCheatPlusSupport> getNoCheatPlus() {
        return this.noCheatPlus;
    }

    public Optional<OpenTerrainGeneratorSupport> getOpenTerrainGenerator() {
        return this.openTerrainGenerator;
    }

    public Optional<PlaceholderAPISupport> getPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public Optional<ProtocolLibSupport> getProtocolLib() {
        return this.protocolLib;
    }

    public Optional<RelicsSupport> getRelics() {
        return this.relics;
    }

    public Optional<VaultSupport> getVault() {
        return this.vault;
    }

    public Optional<WorldGuardSupport> getWorldGuard() {
        return this.worldGuard;
    }
}

