/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import com.sainttx.holograms.HologramPlugin;
import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.HologramManager;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.api.line.TextLine;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.holograms.HologramProvider;
import io.lumine.xikage.mythicmobs.holograms.IHologram;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public class HologramsSupport
implements HologramProvider,
Listener {
    private final MythicMobs core;
    private HologramManager hologramManager;

    public HologramsSupport(MythicMobs mm3) {
        this.core = mm3;
        this.hologramManager = ((HologramPlugin)JavaPlugin.getPlugin(HologramPlugin.class)).getHologramManager();
        if (this.hologramManager == null) {
            return;
        }
    }

    @Override
    public void cleanup() {
        this.hologramManager.getActiveHolograms().values().forEach(hologram -> {
            if (hologram.getId().startsWith("#Temp")) {
                Schedulers.sync().runLater(() -> {
                    hologram.despawn();
                    this.hologramManager.removeActiveHologram(hologram);
                }, 1L);
            }
        });
    }

    @Override
    public IHologram createHologram(String name, AbstractLocation location, String text) {
        return new HologramsHologram(name, location, text);
    }

    public class HologramsHologram
    implements IHologram {
        private Hologram hologram;

        public HologramsHologram(String name, AbstractLocation location, String text) {
            this.hologram = new Hologram(name, BukkitAdapter.adapt(location));
            this.hologram.setPersistent(false);
            this.hologram.addLine((HologramLine)new TextLine(this.hologram, text));
            HologramsSupport.this.hologramManager.addActiveHologram(this.hologram);
        }

        @Override
        public void close() {
            this.hologram.despawn();
            HologramsSupport.this.hologramManager.removeActiveHologram(this.hologram);
        }

        @Override
        public void teleport(AbstractLocation location) {
            this.hologram.teleport(BukkitAdapter.adapt(location));
        }

        @Override
        public void setText(String text) {
            ((TextLine)this.hologram.getLine(0)).setText(text);
        }

        @Override
        public void setText(String[] text, String linePrefix) {
            for (int i = 0; i < this.hologram.getLines().size(); ++i) {
                this.hologram.removeLine(this.hologram.getLine(i));
            }
            for (String string : text) {
                this.hologram.addLine((HologramLine)new TextLine(this.hologram, linePrefix + string));
            }
        }
    }
}

