/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IMultiDrop;
import io.lumine.xikage.mythicmobs.drops.InvalidDrop;
import io.lumine.xikage.mythicmobs.drops.LootBag;
import io.lumine.xikage.mythicmobs.drops.MythicEquipable;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.InvalidCondition;
import io.lumine.xikage.mythicmobs.utils.collections.WeightedCollection;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomDouble;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DropTable {
    private final String fileName;
    private final String internalName;
    protected List<SkillCondition> conditions = new ArrayList<SkillCondition>();
    protected List<SkillCondition> conditionsTrigger = new ArrayList<SkillCondition>();
    private WeightedCollection<Drop> drops = new WeightedCollection();
    private int minItems = -1;
    private int maxItems = -1;
    private RandomDouble bonusLevelItems = new RandomDouble("0");
    private RandomDouble bonusLuckItems = new RandomDouble("0");
    private boolean hasConditions = false;
    private List<MythicEquipable> equipablesList = new ArrayList<MythicEquipable>();

    public DropTable(String file, String name, MythicConfig mc) {
        SkillCondition sc;
        this.fileName = file;
        this.internalName = name;
        int totalItems = mc.getInteger("TotalItems", -1);
        this.maxItems = mc.getInteger("MaxItems", totalItems);
        this.minItems = mc.getInteger("MinItems", totalItems);
        this.bonusLevelItems = new RandomDouble(mc.getString("BonusLevelItems", "0"));
        this.bonusLuckItems = new RandomDouble(mc.getString("BonusLuckItems", "0"));
        List<String> strDrops = mc.getStringList("Drops");
        MythicMobs.inst().getDropManager().queueSecondPass(() -> {
            for (String s2 : strDrops) {
                Drop drop = Drop.getDrop(file, s2 = MythicLineConfig.unparseBlock(s2));
                if (drop instanceof InvalidDrop) continue;
                this.drops.add(drop);
            }
        });
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s2 : nTConditions) {
            sc = SkillCondition.getCondition(s2 = MythicLineConfig.unparseBlock(s2));
            if (sc instanceof InvalidCondition) continue;
            this.conditions.add(sc);
        }
        nTConditions = mc.getStringList("TriggerConditions");
        for (String s2 : nTConditions) {
            sc = SkillCondition.getCondition(s2 = MythicLineConfig.unparseBlock(s2));
            if (sc instanceof InvalidCondition) continue;
            this.conditionsTrigger.add(sc);
        }
    }

    public DropTable(String file, String name, List<String> drops) {
        this(file, name, drops, false);
    }

    public DropTable(String file, String name, List<String> drops, boolean delayed) {
        this.fileName = file;
        this.internalName = name;
        if (delayed) {
            MythicMobs.inst().getDropManager().queueSecondPass(() -> {
                for (String s2 : drops) {
                    Drop drop = Drop.getDrop(file, s2 = MythicLineConfig.unparseBlock(s2));
                    if (drop instanceof InvalidDrop) continue;
                    this.drops.add(drop);
                }
            });
        } else {
            for (String s2 : drops) {
                Drop drop = Drop.getDrop(file, s2 = MythicLineConfig.unparseBlock(s2));
                if (drop instanceof InvalidDrop) continue;
                this.drops.add(drop);
            }
        }
    }

    public boolean hasDrops() {
        return this.drops.size() > 0;
    }

    public LootBag generate(DropMetadata meta) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Generating LootBag", new Object[0]);
        LootBag drops = new LootBag(meta);
        if (this.conditions.size() > 0) {
            for (SkillCondition mc : this.conditions) {
                if (mc.evaluateDropper(meta)) continue;
                return drops;
            }
        }
        if (this.conditionsTrigger.size() > 0) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (mc.evaluateDropCause(meta)) continue;
                return drops;
            }
        }
        int amountModifiers = 0;
        double bonusLevelMod = this.bonusLevelItems.get();
        double bonusLuckMod = this.bonusLuckItems.get();
        if (bonusLevelMod != 0.0) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "BonusLevelMod: {0} - Mob Level: {1}", bonusLuckMod, meta.getDropper().get().getLevel());
            amountModifiers += meta.getDropper().isPresent() ? (int)(meta.getDropper().get().getLevel() * bonusLevelMod) : 0;
        }
        if (bonusLuckMod != 0.0) {
            double causeLuck = meta.getCause().isPresent() ? (double)((int)((double)meta.getCause().get().getLuck() * bonusLuckMod)) : 0.0;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "BonusLuckMod: {0} - Killer Luck: {1}", bonusLuckMod, causeLuck);
            amountModifiers = (int)((double)amountModifiers + causeLuck);
        }
        if (this.minItems > 0 && this.maxItems > 0) {
            int diff = this.maxItems - this.minItems;
            int amount = diff > 0 ? Numbers.randomInt(diff) + this.minItems + amountModifiers : this.maxItems + amountModifiers;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Amount (Rand {1} to {2}): {0}", amount, this.minItems, this.maxItems);
            Collection<Drop> d = this.drops.get(amount);
            for (Drop drop : d) {
                if (this.handleDrop(meta, drops, drop)) continue;
                return drops;
            }
        } else if (this.minItems > 0) {
            int diff = this.drops.size() - this.minItems;
            int amount = diff > 0 ? Numbers.randomInt(diff) + this.minItems + amountModifiers : this.minItems + amountModifiers;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Amount (Min {1}): {0}", amount, this.minItems);
            for (Drop drop : this.drops.get(amount)) {
                if (this.handleDrop(meta, drops, drop)) continue;
                return drops;
            }
        } else if (this.maxItems > 0) {
            int items = 0 - amountModifiers;
            for (Drop drop : this.drops.getView()) {
                if (drop.rollChance()) {
                    ++items;
                    if (!this.handleDrop(meta, drops, drop)) {
                        return drops;
                    }
                }
                if (items < this.maxItems) continue;
                break;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Amount (Max {1}): {0}", items, this.maxItems);
        } else {
            for (Drop drop : this.drops.getView()) {
                if (!drop.rollChance() || this.handleDrop(meta, drops, drop)) continue;
                return drops;
            }
        }
        return drops;
    }

    private boolean handleDrop(DropMetadata meta, LootBag drops, Drop drop) {
        drop.rollAmount(meta);
        if (drop instanceof IMultiDrop) {
            if (meta.tick() > 100) {
                return false;
            }
            int i = 0;
            while ((double)i < drop.getAmount()) {
                drops.add(meta, ((IMultiDrop)((Object)drop)).get(meta));
                ++i;
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Handling Item {0}", drop.getLine());
            drops.add(meta, drop);
        }
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getInternalName() {
        return this.internalName;
    }
}

